<?php
/**
 * single.php
 *
 * The template for displaying single posts.
 */
get_header();
get_template_part( 'content/content', 'single-header' );
$sidebar = beautypress_option( 'single_blog_sidebar', 3 );
$column = ($sidebar == 1 || !is_active_sidebar('sidebar-1')) ? 'col-md-12' : 'col-md-12 col-xl-8 col-lg-8';
$show_banner = xs_post_get_meta(get_the_ID(),'_post_meta', 'show_banner', '',true);
if($show_banner){
	$section_wrape = 'section-padding';
}else{
	$section_wrape = 'xs-section-padding';
}
?>
<section class="main-content">
	<section class="beautypress-blog-post-section <?php echo esc_attr($section_wrape); ?>">
		<div class="container">
			<div class="row">
				<?php
				if ( $sidebar == 2 ) {
					get_sidebar();
				}
				?>
				<div class="<?php echo esc_attr( $column ); ?>">
					<div class="post-content beautypress-blog-post-group single-blog-xs">
						<?php
						while ( have_posts() ) : the_post();
							?>
							<article id="post-<?php the_ID(); ?>" <?php post_class('post-layout'); ?>>
								<?php get_template_part('post-formats/content', get_post_format()); ?>
								<?php
	                            if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;
								?>
							</article>
						<?php endwhile; ?>
					</div>
				</div>
				<?php
				if ( $sidebar == 3 ) {
					get_sidebar();
				}
				?>
			</div>
		</div>
	</section>
</section>
<?php get_footer(); ?>