<?php
/**
 * content.php
 *
 * The default template for displaying content.
 */

$time = strtotime(get_the_date('',get_the_ID()));
$date = date('d',$time);
$month = date('M',$time);
$next_post = get_next_post();
$pre_post = get_previous_post();
$happy = get_post_meta(get_the_id(), '_xs_happy', true ); 
$angry = get_post_meta(get_the_id(), '_xs_angry', true ); 
$sad = get_post_meta(get_the_id(), '_xs_sad', true ); 
$cry = get_post_meta(get_the_id(), '_xs_cry', true );
$show_reaction = beautypress_option( 'show_reaction', '' );
$show_social_share = beautypress_option( 'show_social_share', '' );
?>

<div class="beautypress-blog-post-wraper">
	<?php 
		if(has_post_thumbnail()):
			$thumbnail	 = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), '' );
			$img = xs_resize( $thumbnail[0], 730, 379 );
	?>
		<img class="beautypress-feature-image" src="<?php echo esc_url($img); ?>" alt="<?php echo get_the_title(); ?>">
	<?php endif; ?>
	<div class="entry-header">
		<div class="post-meta">
			<div class="beautypress-tag">
				<?php the_tags('',''); ?>
			</div>
		</div>

		<h2 class="entry-title"><?php the_title(); ?></h2>
	</div>
	<div class="entry-content">
		<?php the_content();?>
	</div>
	<?php
        $defaults = array(
                'before'           => '<div class="beautypress-pagininner">' . esc_html__( 'Pages:', 'beautypress' ),
                'after'            => '</div>',
                'link_before'      => '<span>',
                'link_after'       => '</span>',
                'next_or_number'   => 'number',
                'separator'        => ' ',
                'nextpagelink'     => __( '<i class="fas fa-angle-right"></i>', 'beautypress'),
                'previouspagelink' => __( '<i class="fas fa-angle-left"></i>', 'beautypress' ),
                'pagelink'         => '%',
                'echo'             => 1
        );
        wp_link_pages( $defaults );
   ?>
</div>

<?php if ( (class_exists( 'Xs_Main' ))  && (!empty($show_reaction)) ): ?>
	<div class="beautypress-react-container mb-30">
		<div class="beautypress-simple-title mb-30">
			<h3><?php echo esc_html__( 'Show Your Reaction', 'beautypress' ) ?></h3>
		</div>
		<ul class="beautypress-react">
			<li><a href="" data-id="<?php echo get_the_ID(); ?>" data-emoji="_xs_happy"><i class="xsicon icon-happiness"></i></a><span><?php echo (empty( $happy )) ? 0 : esc_html( $happy ); ?></span></li>
			<li><a href="" data-id="<?php echo get_the_ID(); ?>" data-emoji="_xs_angry"><i class="xsicon icon-happiness-1"></i></a><span><?php echo (empty( $angry )) ? 0 : esc_html( $angry ); ?></span></li>
			<li><a href="" data-id="<?php echo get_the_ID(); ?>" data-emoji="_xs_sad"><i class="xsicon icon-sad"></i></a><span><?php echo (empty( $sad )) ? 0 : esc_html( $sad ); ?></span></li>
			<li><a href="" data-id="<?php echo get_the_ID(); ?>" data-emoji="_xs_cry"><i class="xsicon icon-feelings"></i></a><span><?php echo (empty( $cry )) ? 0 : esc_html( $cry ); ?></span></li>
		</ul>
	</div>
<?php endif; ?>
<?php if ( (class_exists( 'Xs_Main' ))  && (!empty($show_social_share)) ): ?>
	<div class="beautypress-spilit-container beautypress-share-timeline">
		<div class="beautypress-simple-title">
			<h3><?php echo esc_html__( 'Share with your timeline', 'beautypress' ) ?></h3>
		</div><!-- .beautypress-simple-title END -->
		<div class="beautypress-footer-social text-right">
			<ul class="beautypress-social-list">
				<?php
				$Xs_Social = Xs_Main::xs_get_instance();
				$Xs_Social->get_social_share();
				?>
			</ul><!-- .beautypress-social-list END -->
		</div>
	</div>
<?php endif; ?>

<div class="beautypress-spilit-container mb-70">

	<?php if(!empty($pre_post)): ?>
		<div class="beautypress-simple-title text-left">
			<h5><?php echo esc_html__( 'Previous Post', 'beautypress' ) ?></h5>
			<a href="<?php echo get_the_permalink($pre_post->ID); ?>"><?php echo get_the_title( $pre_post->ID ) ?></a>
		</div>
	<?php endif; ?>
	
	<?php if(!empty($next_post)): ?>
		<div class="beautypress-simple-title text-right">
			<h5><?php echo esc_html__( 'Next Post', 'beautypress' ) ?></h5>
			<a href="<?php echo get_the_permalink($next_post->ID); ?>"><?php echo get_the_title( $next_post->ID ) ?></a>
		</div>
	<?php endif; ?>
</div>

