<?php
/**
 *
 * The template for displaying all pages.
 */

get_header();
get_template_part( 'content/content', 'page-header' );
$show_banner = xs_post_get_meta(get_the_ID(),'_page_meta', 'show_banner', '',true);
$sidebar = beautypress_option('page_sidebar',3);
$column = ($sidebar == 1 || !is_active_sidebar('sidebar-1')) ? 'col-md-12' : 'col-md-12 col-xl-8 col-lg-8';
$title = xs_post_get_meta(get_the_ID(),'_page_meta', 'banner_title','');
if($title == ''){
	$title = get_the_title();
}
?>
<section class="main-content">
	<section class="beautypress-pagefeed-section <?php echo ($show_banner) ? 'section-padding' : 'xs-section-padding' ?>">
	    <div class="container">
			<div class="row">
				<?php
				if($sidebar == 2){
					get_sidebar();
				}
				?>
				<div class="<?php echo esc_attr($column); ?>">
					<?php while ( have_posts() ) : the_post(); ?>
						<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
							<h2 class="entry-title"><?php echo esc_html($title); ?></h2>
							<!-- Article content -->
							<div class="full-width-content entry-content">
								<?php the_content(); ?>
								<?php beautypress_link_pages(); ?>
							</div> <!-- end entry-content -->
							<?php
	                        if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;
							?>
							<!-- Article footer -->
							<footer class="entry-footer">
								<?php
								if ( is_user_logged_in() ) {
									echo '<p>';
									edit_post_link( esc_html__( 'Edit', 'beautypress' ), '<span class="meta-edit">', '</span>' );
									echo '</p>';
								}
								?>
							</footer> <!-- end entry-footer -->
						</article>
					<?php endwhile; ?>
				</div>
				<?php
				if($sidebar == 3){
					get_sidebar();
				}
				?>
	    	</div>
	    </div>
	</section>
</section>
<?php get_footer(); ?>