<?php
/**
 * The main template file
 */
get_header();


get_template_part( 'content/content', 'blog-header' );

$sidebar = beautypress_option( 'blog_sidebar', 3 );
$column = ($sidebar == 1 || !is_active_sidebar('sidebar-1')) ? 'col-md-12' : 'col-md-12 col-xl-8 col-lg-8';
$show_blog_header = beautypress_option( 'show_blog_header');
if($show_blog_header){
	$section_wrape = 'section-padding';
}else{
	$section_wrape = 'xs-section-padding';
}
?>
<section class="main-content">
	<section class="beautypress-newsfeed-section <?php echo esc_attr($section_wrape); ?>">
		<div class="container">
			<div class="row">
				<?php
				if ( $sidebar == 2 ) {
					get_sidebar();
				}
				?>
				<div class="<?php echo esc_attr( $column ); ?>">
					<div class="row">
						<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
								<div class="col-md-12 col-sm-12 col-xl-<?php echo beautypress_option( 'element_per_row', 6 ); ?> col-lg-<?php echo beautypress_option( 'element_per_row', 4 ); ?>">
									<div class="beautypress-single-newsletter">
										<?php beautypress_post_thumbnail(); ?>
										<div class="beautypress-newsfeed-footer">
											<?php
											if ( is_sticky() ) {
												echo '<span class="stickys">' . esc_html__( 'featured', 'beautypress' ) . '</span>';
											}
											?>
											<a href="<?php echo get_the_permalink(); ?>"><?php the_title() ?></a>
											<?php beautypress_excerpt( 55 ); ?>
										</div>
									</div>
								</div>
							<?php endwhile; ?>
						</div>
						<?php beautypress_paging_nav(); ?>
					<?php else : ?>
						<?php get_template_part( 'content/content', 'none' ); ?>
					<?php endif; ?>
				</div>
				<?php
				if ( $sidebar == 3 ) {
					get_sidebar();
				}
				?>
			</div>
		</div>
	</section>
</section>
<?php get_footer(); ?>
