<?php

if ( !defined( 'ABSPATH' ) )
	die( 'Direct access forbidden.' );
/**
 * Enqueue all theme scripts and styles
 *

  /** --------------------------------------
 * ** REGISTERING THEME ASSETS
 * ** ------------------------------------ */
/**
 * Enqueue styles.
 */
if ( !is_admin() ) {
	wp_enqueue_style('beautypress-fonts', beautypress_google_fonts_url(), null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-bootstrap-min', BEAUTYPRESS_CSS . '/bootstrap.min.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'xs-blog', BEAUTYPRESS_CSS . '/blog.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-bootstrap-datepicker-min', BEAUTYPRESS_CSS . '/bootstrap-datepicker.min.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-font-awesome-min', BEAUTYPRESS_CSS . '/font-awesome.min.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-font-xs-icon', BEAUTYPRESS_CSS . '/xs-icon.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-owlmin-carousel-min', BEAUTYPRESS_CSS . '/owl.carousel.min.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-isotope', BEAUTYPRESS_CSS . '/isotope.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-magnific-popup', BEAUTYPRESS_CSS . '/magnific-popup.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-plugins', BEAUTYPRESS_CSS . '/plugins.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-style', BEAUTYPRESS_CSS . '/style.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-custom', BEAUTYPRESS_CSS . '/custom.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-woocommerce', BEAUTYPRESS_CSS . '/xs-woocommerce.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-responsive', BEAUTYPRESS_CSS . '/responsive.css', null, BEAUTYPRESS_VERSION );
	wp_enqueue_style( 'beautypress-gutenberg-custom', BEAUTYPRESS_CSS . '/gutenberg-custom.css', null, BEAUTYPRESS_VERSION );
}

/**
 * Enqueue scripts.
 */
if ( !is_admin() ) {
	$map_api_code = beautypress_option( 'gmap_api');
    $apic = ($map_api_code != '') ? '?key='.$map_api_code : '';

	wp_enqueue_script( 'beautypress-plugins', BEAUTYPRESS_SCRIPTS . '/plugins.js', array( 'jquery' ), BEAUTYPRESS_VERSION, true );
	wp_enqueue_script( 'beautypress-bootstrap-min', BEAUTYPRESS_SCRIPTS . '/bootstrap.min.js', array( 'beautypress-plugins' ), BEAUTYPRESS_VERSION, true );
	wp_enqueue_script( 'beautypress-datepicker-min', BEAUTYPRESS_SCRIPTS . '/bootstrap-datepicker.min.js', array( 'beautypress-bootstrap-min' ), BEAUTYPRESS_VERSION, true );

	wp_enqueue_script( 'isotope', BEAUTYPRESS_SCRIPTS . '/isotope.pkgd.min.js', array( 'beautypress-datepicker-min' ), BEAUTYPRESS_VERSION, true );
	wp_enqueue_script( 'owl-carousel', BEAUTYPRESS_SCRIPTS . '/owl.carousel.min.js', array( 'isotope' ), BEAUTYPRESS_VERSION, true );
	wp_enqueue_script( 'magnific-popup', BEAUTYPRESS_SCRIPTS . '/jquery.magnific-popup.min.js', array( 'owl-carousel' ), BEAUTYPRESS_VERSION, true );
	wp_enqueue_script( 'xs-appear', BEAUTYPRESS_SCRIPTS . '/appear.js', array( 'magnific-popup' ), BEAUTYPRESS_VERSION, true );
	wp_enqueue_script( 'xs-hover', BEAUTYPRESS_SCRIPTS . '/jquery.ajaxchimp.min.js', array( 'xs-appear' ), BEAUTYPRESS_VERSION, true );
	wp_enqueue_script( 'xs-mailchimp', BEAUTYPRESS_SCRIPTS . '/jquery.hover3d.min.js', array( 'xs-hover' ), BEAUTYPRESS_VERSION, true );
	wp_enqueue_script( 'xs-maps-googleapis', 'https://maps.googleapis.com/maps/api/js'.$apic, array( 'xs-mailchimp' ), '', TRUE );
	wp_enqueue_script( 'beautypress-main', BEAUTYPRESS_SCRIPTS . '/main.js', array( 'xs-maps-googleapis' ), BEAUTYPRESS_VERSION, true );

	wp_enqueue_script( 'beautypress-ajax', BEAUTYPRESS_SCRIPTS . '/ajax.js', array('beautypress-main'), '',TRUE );

    /*React Ajax Call*/
    $params = array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'ajax_nonce' => wp_create_nonce('xs_post_react_nonce'),
    );
    wp_localize_script('beautypress-ajax', 'xs_ajax_obj', $params);



	// Load WordPress Comment js
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

wp_localize_script( 'sassico-customize', 'admin_url_object',array( 'admin_url' => admin_url( 'post.php?action=elementor&post=' ) ) );