<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class XS_Video_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-video';
    }

    public function get_title() {
        return __( 'beautypress Video Box', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-youtube';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('beautypress Video Box', 'beautypress'),
            ]
        );

        $this->add_control(

            'style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                    'style3' => __('Style 3', 'beautypress'),
                ],
            ]
        );

        $this->add_control(
			'video_link',
			[
				'label' => __( 'Link', 'beautypress' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __('http://your-link.com','beautypress' ),

			]
		);

		$this->add_control(
			'video_thumbnail',
			[
				'label' => __( 'Thumbnail Image', 'beautypress' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
                'condition' =>  [
                    'style' => ['style1','style2'],
                ],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(

            'style_general_tab',
            [
                'label' =>  __( 'General', 'beautypress' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' =>  [
                    'style' => 'style3'
                ],
            ]
            
        );
        $this->add_responsive_control(
            'btn_align',
            [
                'label' => __( 'Alignment', 'beautypress' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __( 'Left', 'beautypress' ),
                        'icon' => 'fas fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'beautypress' ),
                        'icon' => 'fas fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'beautypress' ),
                        'icon' => 'fas fa-align-right',
                    ],
                ],
                'prefix_class' => 'text-%s',
                'default' => '',
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(

        	'style_tab',
        	[
        		'label'	=>	__( 'Style', 'beautypress' ),
        		'tab' 	=> Controls_Manager::TAB_STYLE,
        	]
        );

        $this->add_control(
        	'border',
        	[
        		'label'	=>	__('Show Border','beautypress'),
        		'type'	=> Controls_Manager::SWITCHER,
        		'default' => 'yes',
				'label_on' => __( 'Yes', 'beautypress' ),
				'label_off' => __( 'No', 'beautypress' ),
                'condition' =>  [
                    'style' => ['style1','style2'],
                ],
        	]

        );

	    $this->add_control(
		    'border_width',
		    [
		        'label' => __( 'Border Width', 'beautypress' ),
		        'type' => Controls_Manager::SLIDER,
		        'default' => [
		            'size' => '',
		        ],
		        'range' => [
		                'min' => 0,
		                'max' => 100,
		                'step' => 1,
		        ],
		        'size_units' => [ 'px'],
		        'condition'	=>	[
        			'border'	=> 'yes',
        		],
		        'selectors'	=>	[
        			'{{WRAPPER}} .beautypress-border:before' => 'border: {{SIZE}}px solid;',
        			'{{WRAPPER}} .beautypress-border' => 'border: {{SIZE}}px solid;',
        		],
                'condition' =>  [
                    'style' => ['style1','style2'],
                ],
		    ]
		);

        $this->add_control(
        	'border_color',
        	[
        		'label'	=>	__('Border Color','beautypress'),
        		'type'	=> Controls_Manager::COLOR,
        		'selectors'	=>	[
        			'{{WRAPPER}} .beautypress-border:before' => 'border-color: {{VALUE}};',
        			'{{WRAPPER}} .beautypress-border' => 'border-color: {{VALUE}};',
        		],
        		'condition'	=>	[
        			'style' => ['style1','style2'],
        			'border'	=> 'yes',
        		],
        	]
        );

        $this->add_control(
            'btn_bg_color',
            [
                'label' =>  __('Button BG Color','beautypress'),
                'type'  => Controls_Manager::COLOR,
                'selectors' =>  [
                    '{{WRAPPER}} a.beautypress-video-popup' => 'background-color: {{VALUE}} !important;'
                ],
                
            ]
        );

        $this->add_control(
            'btn_icon_color',
            [
                'label' =>  __('Icon Color','beautypress'),
                'type'  => Controls_Manager::COLOR,
                'selectors' =>  [
                    '{{WRAPPER}} a.beautypress-video-popup' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(

        	'style_background_tab',
        	[
        		'label'	=>	__( 'Background', 'beautypress' ),
        		'tab' 	=> Controls_Manager::TAB_STYLE,
                'condition' =>  [
                    'style' => ['style1','style2']
                ],
        	]
            
        );
        $this->add_control(
        	'bg_color',
        	[
        		'label'	=>	__('Background Color','beautypress'),
        		'type'	=> Controls_Manager::COLOR,
        		'selectors'	=>	[
        			'{{WRAPPER}} .beautypress-border:before' => 'background:{{VALUE}};',
        		],
        		'condition'	=>	[
        			'style' => 'style1',
        			'border'	=> 'yes',
        		],
        	]
        );

        $this->add_control(
        	'bg_overlay_color',
        	[
        		'label'	=>	__('Background Overlay Color','beautypress'),
        		'type'	=> Controls_Manager::COLOR,
        		'selectors'	=>	[
        			'{{WRAPPER}} .beautypress-border:after' => 'background-image: -webkit-linear-gradient( 90deg, rgb(0,188,212) 0%, {{VALUE}} 0%, rgba(151,95,184,0.5) 30%, rgba(255,255,255,0) 100%);',
        		],
        	]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();

        $style = $settings['style'];

        $video_link = $settings['video_link'];

        $video_thumbnail = $settings['video_thumbnail'];

        $border = ($settings['border']) ? 'beautypress-border' : 'xs-video-border-none';

        ?>
        <?php if($style == 'style1'): ?>
			<div class="beautypress-video-popup-content">
				<div class="beautypress-video-popup-content-inner beautypress-border beautypress-version-2 <?php echo esc_attr($border); ?>">
					<img src="<?php echo esc_url( $video_thumbnail['url'] ) ?>" alt="<?php esc_attr_e('thumbnail', 'beautypress') ?>">
					<a href="<?php echo esc_url( $video_link ); ?>" class="beautypress-video-popup beautypress-video-popup-btn bg-color-pink">
						<i class="fas fa-play"></i>
					</a>
				</div>
			</div>
		<?php elseif($style == 'style2'): ?>
			<div class="beautypress-video-popup-content">
				<div class="beautypress-video-popup-content-inner video-popup-nomargin <?php echo esc_attr($border); ?>">
					<img src="<?php echo esc_url( $video_thumbnail['url'] ) ?>" alt="<?php esc_attr_e('thumbnail', 'beautypress') ?>">
					<a href="<?php echo esc_url( $video_link ); ?>" class="beautypress-video-popup beautypress-video-popup-btn bg-color-pink">
						<i class="fas fa-play"></i>
					</a>
				</div>
			</div>
        <?php elseif($style == 'style3'): ?>
            <div class="beautypress-video-sections-content">
                <a href="<?php echo esc_url( $video_link ); ?>" class="beautypress-video-popup beautypress-video-popup-btn bg-color-purple">
                    <i class="fas fa-play"></i>
                </a>
            </div>
		<?php endif; ?>
        <?php
    }



    protected function content_template() { }
}