<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Testimonial_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-testimonial';
    }

    public function get_title() {
        return __( 'Beautypress Testimonial', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-testimonial';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab_style',
            [
                'label' => __('Beautypress Testimonial', 'beautypress'),
            ]
        );

        $this->add_control(

            'style',
            [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                ],
            ]
        );

        /**
         *
         * Testimonial Style1
         *
         */

        $repeater = new Repeater();

		$repeater->add_control(
			'client_name', [
                'label' => __('Client Name', 'beautypress'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
			]
		);

		$repeater->add_control(
			'review', [
                'label' => __('Testimonial', 'beautypress'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater->add_control(
			'rating',
			[
                'label'     => esc_html__( 'Rating', 'beautypress' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    1    =>  1,
                    2    =>  2,
                    3    =>  3,
                    4    =>  4,
                    5    =>  5,
                ],
			]
		);

		$repeater->add_control(
			'signature',
			[
                'label' => __('Signature', 'beautypress'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
			]
		);

		$this->add_control(
			'testimonial',
            [
                'label' => __('Tetimonial', 'beautypress'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'separator' => 'before',
                'default' => [
                    [
                        'client_name' => __('Testimonial #1', 'beautypress'),
                        'review' => __('The bedding was hardly able to cover it and seemed ready to slide off any moment. His many legs, pitifully thin compared with the size of the rest of him, waved about helplessly as he looked', 'beautypress'),
                        'rating' => 5,
                        'signature' => __('CEO', 'beautypress'),
                    ],

                    [
                        'client_name' => __('Testimonial #1', 'beautypress'),
                        'review' => __('The bedding was hardly able to cover it and seemed ready to slide off any moment. His many legs, pitifully thin compared with the size of the rest of him, waved about helplessly as he looked', 'beautypress'),
                        'rating' => 5,
                        'signature' => __('CEO', 'beautypress'),
                    ],

                    [
                        'client_name' => __('Testimonial #1', 'beautypress'),
                        'review' => __('The bedding was hardly able to cover it and seemed ready to slide off any moment. His many legs, pitifully thin compared with the size of the rest of him, waved about helplessly as he looked', 'beautypress'),
                        'rating' => 5,
                        'signature' => __('CEO', 'beautypress'),
                    ],
                ],
				'condition' => [
                    'style' => 'style1',
                ],
                'title_field' => '{{{ client_name }}}',
			]
		);

        /**
         *
         * Testimonial Style2
         *
         */

        $this->add_control(

            'client_name',
            [

                'label' => __('Client Name', 'beautypress'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default'   => __('Testimonial #1', 'beautypress'),
                'separator' => 'before',
                'condition' =>  [
                    'style' =>  'style2'
                ],
            ]
        );

        $this->add_control(

            'review',
            [

                'label' => __('Testimonial', 'beautypress'),
                'type' => Controls_Manager::TEXTAREA,
                'default'    => __('The bedding was hardly able to cover it and seemed ready to slide off any moment. His many legs, pitifully thin compared with the size of the rest of him, waved about helplessly as he looked', 'beautypress'),
                'label_block' => true,
                'condition' =>  [
                    'style' =>  'style2'
                ],
            ]
        );

        $this->add_control(

            'rating',
            [

                'label'     => esc_html__( 'Rating', 'beautypress' ),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    1    =>  1,
                    2    =>  2,
                    3    =>  3,
                    4    =>  4,
                    5    =>  5,
                ],
                'default'   => 5,
                'condition' =>  [
                    'style' =>  'style2'
                ],
            ]
        );

        $this->add_control(

            'signature',
            [

                'label'     => esc_html__( 'Image', 'beautypress' ),
                'type' => Controls_Manager::MEDIA,
                        'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
                'condition' =>  [
                    'style' =>  'style2'
                ],
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Client Name
         *
         */


        $this->start_controls_section(
            'section_name_style',
            [
                'label' => __('Name', 'beautypress'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-best-reviewr-content h3 ' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .beautypress-single-testimonial h2 ' => 'color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'name_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-best-reviewr-content h3,
                              {{WRAPPER}} .beautypress-single-testimonial h2',
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Testimonial
         *
         */


        $this->start_controls_section(
            'section_testimonial_style',
            [
                'label' => __('Testimonial', 'beautypress'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'tetimonial_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-best-reviewr-content p' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .beautypress-single-testimonial p ' => 'color: {{VALUE}};',
                ],
            ]
        );



        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'testimonial_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-best-reviewr-content p,
                              {{WRAPPER}} .beautypress-single-testimonial p',
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Rating
         *
         */


        $this->start_controls_section(
            'section_rating_style',
            [
                'label' => __('Rating', 'beautypress'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'rating_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} ul.beautypress-rating li a ' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .beautypress-beauty-product-footer h3 ' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'rating_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} ul.beautypress-rating li a,
                              {{WRAPPER}} .beautypress-beauty-product-footer h3',
            ]
        );

        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        $style = $settings['style'];

        $testimonial = $settings['testimonial'];

        $client_name = $settings['client_name'];

        $review = $settings['review'];

        $rating = $settings['rating'];

        $signature = $settings['signature'];

        switch ($style) {
            case 'style1':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/testimonial/style1.php');
                break;

            case 'style2':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/testimonial/style2.php');
                break;
        }
        ?>
    <?php
    }

    protected function content_template() { }
}