<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Team_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-team';
    }

    public function get_title() {
        return esc_html__( 'Beautypress Team', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Beautypress Team', 'beautypress'),
            ]
        );

        /**
         *
         * Member Content Feild
         *
        */

        $this->add_control(
            'style',
            [
                'label'     => esc_html__( 'Style', 'beautypress' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'style1',
                'options'   => [
                        'style1'     => esc_html__( 'Style 1', 'beautypress' ),
                        'style2'     => esc_html__( 'Style 2', 'beautypress' ),
                        'style3'     => esc_html__( 'Style 3', 'beautypress' ),
                        'style4'     => esc_html__( 'Style 4', 'beautypress' ),
                ],
            ]
        );

        $this->add_control(

            'member_name',
            [

                'label' => __('Team Member', 'beautypress'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default'   => __('Team Member', 'beautypress'),
                'condition' =>  [
                    'style' => ['style1','style2','style4'],
                ],
            ]
        );

        $this->add_control(

            'member_position',
            [

                'label' => __('Position', 'beautypress'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default'   => __('CEO', 'beautypress'),
                'condition' =>  [
                    'style' => ['style1','style2','style4'],
                ],
            ]
        );

        $this->add_control(

            'member_details',
            [

                'label' => __('Details', 'beautypress'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default'   => __('One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly ', 'beautypress'),
                'condition' =>  [
                    'style' => ['style1','style2','style4']
                ],
            ]
        );

        $this->add_control(

            'member_image',
            [
                'label' => __('Team Member Image', 'beautypress'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
                'condition' =>  [
                    'style' => ['style1','style2','style4']
                ],
            ]
        );

        $this->add_control(

            'member_show_social',
            [
                'label'         => __( 'Show Social', 'beautypress' ),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'yes',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
                'condition' =>  [
                    'style' => ['style1','style4']
                ],
            ]
        );

        $this->add_control(
            'facebook_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Facebook URL', 'beautypress'),
                'description' => __('URL of the Facebook of the team member.', 'beautypress'),
                'default'   =>  '#',
                'condition' => [
                    'member_show_social' => 'yes',
                    'style' => ['style1','style4'],
                ],
            ]
        );

        $this->add_control(
            'twitter_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Twitter URL', 'beautypress'),
                'description' => __('URL of the Twitter of the team member.', 'beautypress'),
                'default'   =>  '#',
                'condition' => [
                    'member_show_social' => 'yes',
                    'style' => ['style1','style4']
                ],
            ]
        );

        $this->add_control(
            'linkedin_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('LinkedIn URL', 'beautypress'),
                'description' => __('URL of the LinkedIn of the team member.', 'beautypress'),
                'condition' => [
                    'member_show_social' => 'yes',
                    'style' => ['style1','style4']
                ],
            ]
        );

        $this->add_control(
            'pinterest_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Pinterest URL', 'beautypress'),
                'description' => __('URL of the Pinterest of the team member.', 'beautypress'),
                'default'   =>  '#',
                'condition' => [
                    'member_show_social' => 'yes',
                    'style' => ['style1','style4']
                ],
            ]
        );

        $this->add_control(
            'dribbble_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Dribbble URL', 'beautypress'),
                'description' => __('URL of the Dribbble of the team member.', 'beautypress'),
                'default'   =>  '#',
                'condition' => [
                    'member_show_social' => 'yes',
                    'style' => ['style1','style4']
                ],
            ]
        );

        $this->add_control(
            'google_plus_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('GooglePlus URL', 'beautypress'),
                'description' => __('URL of the GooglePlus of the team member.', 'beautypress'),
                'condition' => [
                    'member_show_social' => 'yes',
                    'style' => ['style1','style4']
                ],
            ]
        );

        $this->add_control(
            'instagram_url',
            [
                'type' => Controls_Manager::TEXT,
                'label' => __('Instagram URL', 'beautypress'),
                'description' => __('URL of the Instagram of the team member.', 'beautypress'),
                'condition' => [
                    'member_show_social' => 'yes',
                    'style' => ['style1','style4']
                ],
            ]
        );

        $this->add_control(

            'btn_label',
            [

                'label' => __('Button Label', 'beautypress'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default'   => __('LEARN MORE', 'beautypress'),
                'condition' =>  [
                    'style' => ['style4'],
                ],
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => __( 'Link', 'beautypress' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __('http://your-link.com','beautypress' ),
                'default' => [
                    'url' => '',
                ],
                'condition' =>  [
                    'style' => ['style4'],
                ],
            ]
        );

        $team_members = new Repeater();

		$team_members->add_control(
			'member_name', [
                'label' => __('Member Name', 'beautypress'),
                'type' => Controls_Manager::TEXT,
			]
		);

		$team_members->add_control(
			'member_position', [
                'label' => __('Position', 'beautypress'),
                'type' => Controls_Manager::TEXT,
			]
		);

		$team_members->add_control(
			'member_details',
			[
                'label' => __('Details', 'beautypress'),
                'type' => Controls_Manager::TEXTAREA,
			]
		);

		$team_members->add_control(
			'btn_label',
			[
                'label' => __('Button Label', 'beautypress'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default'   => __('LEARN MORE', 'beautypress'),
			]
		);

		$team_members->add_control(
			'btn_link',
			[
                'label' => __( 'Link', 'beautypress' ),
                'type' => Controls_Manager::URL,
                'placeholder' => __('http://your-link.com','beautypress' ),
                'default' => [
                    'url' => '',
                ],
			]
		);

		$team_members->add_control(
			'member_image',
			[
                'label' => __('Team Member Image', 'beautypress'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
			]
		);

		$team_members->add_control(
			'member_show_social',
			[
                'label'         => __( 'Show Social', 'beautypress' ),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'yes',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
			]
		);

		$team_members->add_control(
			'facebook_url',
			[
                'type' => Controls_Manager::TEXT,
                'label' => __('Facebook URL', 'beautypress'),
                'description' => __('URL of the Facebook of the team member.', 'beautypress'),
                'default'   =>  '#',
                'condition' => [
                    'member_show_social' => 'yes',
                ],
			]
		);

		$team_members->add_control(
			'twitter_url',
			[
                'type' => Controls_Manager::TEXT,
                'label' => __('Twitter URL', 'beautypress'),
                'description' => __('URL of the Twitter of the team member.', 'beautypress'),
                'default'   =>  '#',
                'condition' => [
                    'member_show_social' => 'yes',
                ],
			]
		);

		$team_members->add_control(
			'linkedin_url',
			[
                'type' => Controls_Manager::TEXT,
                'label' => __('LinkedIn URL', 'beautypress'),
                'description' => __('URL of the LinkedIn of the team member.', 'beautypress'),
                'condition' => [
                    'member_show_social' => 'yes',
                ],
			]
		);

		$team_members->add_control(
			'pinterest_url',
			[
                'type' => Controls_Manager::TEXT,
                'label' => __('Pinterest URL', 'beautypress'),
                'description' => __('URL of the Pinterest for the team member.', 'beautypress'),
                'default'   =>  '#',
                'condition' => [
                    'member_show_social' => 'yes',
                ],
			]
		);

		$team_members->add_control(
			'dribbble_url',
			[
                'type' => Controls_Manager::TEXT,
                'label' => __('Dribbble URL', 'beautypress'),
                'description' => __('URL of the Dribbble of the team member.', 'beautypress'),
                'default'   =>  '#',
                'condition' => [
                    'member_show_social' => 'yes',
                ],
			]
		);

		$team_members->add_control(
			'google_plus_url',
			[
                'type' => Controls_Manager::TEXT,
                'label' => __('GooglePlus URL', 'beautypress'),
                'description' => __('URL of the Google Plus of the team member.', 'beautypress'),
                'condition' => [
                    'member_show_social' => 'yes',
                ],
			]
		);

		$team_members->add_control(
			'instagram_url',
			[
                'type' => Controls_Manager::TEXT,
                'label' => __('Instagram URL', 'beautypress'),
                'description' => __('URL of the Instagram for the team member.', 'beautypress'),
                'condition' => [
                    'member_show_social' => 'yes',
                ],
			]
		);

		$this->add_control(
			'team_members',
            [
                'label' => __('Team Members', 'beautypress'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $team_members->get_controls(),
                'separator' => 'before',
                'condition' => [
                    'style' =>  'style3'
                ],
                'default' => [
                    [
                        'member_name' => __('Team Member #1', 'beautypress'),
                        'member_position' => __('CEO', 'beautypress'),
                        'member_details' => __('One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections. ', 'beautypress'),
                        'btn_label' => __('Learn More', 'beautypress'),
                    ],

                    [
                        'member_name' => __('Team Member #2', 'beautypress'),
                        'member_position' => __('Lead Developer', 'beautypress'),
                        'member_details' => __('One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections. ', 'beautypress'),
                        'btn_label' => __('Learn More', 'beautypress'),

                    ],

                    [
                        'member_name' => __('Team Member #3', 'beautypress'),
                        'member_position' => __('Finance Manager', 'beautypress'),
                        'member_details' => __('One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections. ', 'beautypress'),
                        'btn_label' => __('Learn More', 'beautypress'),

                    ],
                ],
				'title_field' => '{{{ member_name }}}',
			]
		);

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label'     => __( 'Team Style', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'tabs_style' );

        /**
         *
         * Normal Style
         *
         */

        $this->start_controls_tab(
            'tab_normal',
            [
                'label' => __( 'Normal', 'beautypress' ),
            ]
        );

        $this->add_control(
            'member_name_color',
            [
                'label'     => __( 'Name color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-team-person-details h3' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-single-team-slider h3' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-team-content-v3 h3' => 'color: {{VALUE}};',
                ],
                'condition' => [
                            'style' => ['style1','style3','style4']
                ],
            ]
        );

        $this->add_control(
            'member_pos_color',
            [
                'label'     => __( 'Possition color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-team-person-details h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-single-team-slider h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-team-content-v3 h4' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'style' => ['style1','style3','style4']
                ],
            ]
        );

        $this->add_control(
            'member_details_color',
            [
                'label'     => __( 'Details color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-team-person-details p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-single-team-slider p' => 'color: {{VALUE}};',
                    //'{{WRAPPER}} .beautypress-team-content-v3 p' => 'color: {{VALUE}};',
                ],
                'condition' => [
                            'style' => ['style3']
                ],
            ]
        );

        $this->add_control(
            'member_btn_color',
            [
                'label'     => __( 'Button Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team-slider .beautypress-btn.small-round-btn' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-team-content-v3 .beautypress-btn.small-round-btn' => 'color: {{VALUE}} !important;',
                ],
                'condition' => [
                    'style' => ['style3','style4']
                ],
            ]
        );

        $this->add_control(
            'member_btn_bg_color',
            [
                'label'     => __( 'Button BG Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team-slider .beautypress-btn.small-round-btn' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-team-content-v3 .beautypress-btn.small-round-btn' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'style' => ['style3','style4']
                ],
            ]
        );

        $this->add_control(
            'member_bg_color',
            [
                'label'     => __( 'Backgound Overlay color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team.beautypress-purple-overlay:before' => 'background-image:-webkit-linear-gradient( 90deg, rgb(211,16,39) 0%, {{VALUE}} 0%, rgba(255,255,255,0) 50%);',
                    '{{WRAPPER}} .beautypress-single-team-v3 .beautypress-chocolate-overlay:before' => 'background-image:-webkit-linear-gradient( 90deg, rgb(211,16,39) 0%, {{VALUE}} 0%, rgba(255,255,255,0) 50%);',
                ],
                'condition' => [
                            'style' => ['style1','style4']
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'member_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-team-person-details h3, {{WRAPPER}} .beautypress-team-person-details h4, {{WRAPPER}} .beautypress-single-team-slider h3, {{WRAPPER}} .beautypress-single-team-slider h4, {{WRAPPER}} .beautypress-single-team-slider p, {{WRAPPER}} .beautypress-team-content-v3 p, {{WRAPPER}} .beautypress-team-content-v3 h3, {{WRAPPER}} .beautypress-team-content-v3 h4',
                'condition' => [
                    'style' => ['style1','style3','style4']
                ],
            ]
        );

        $this->end_controls_tab();

        /**
         *
         * Hover Style
         *
         */


        $this->start_controls_tab(
            'tab_hover',
            [
                'label' => __( 'Hover', 'beautypress' ),
            ]
        );

        $this->add_control(
            'member_name_hover_color',
            [
                'label'     => __( 'Name color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team:hover h3' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-single-team-v3.hover h3' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'style' => ['style1','style2','style4']
                ],
            ]
        );

        $this->add_control(
            'member_pos_hover_color',
            [
                'label'     => __( 'Possition color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team:hover h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-single-team-v3.hover h4' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'style' => ['style1','style2','style4']
                ],
            ]
        );

        $this->add_control(
            'member_details_hover_color',
            [
                'label'     => __( 'Details color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team:hover p' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-single-team-v3.hover p' => 'color: {{VALUE}};',
                ],
                'condition' => [
                            'style' => ['style2','style4']
                ],
            ]
        );

        $this->add_control(
            'member_btn_hover_color',
            [
                'label'     => __( 'Button Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team-slider .beautypress-btn:hover' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .beautypress-team-content-v3 .beautypress-btn:hover' => 'color: {{VALUE}} !important;',
                ],
                'condition' => [
                            'style' => ['style3','style4']
                ],
            ]
        );

        $this->add_control(
            'member_btn_bg_hover_color',
            [
                'label'     => __( 'Button BG Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team-slider .beautypress-btn.small-round-btn span' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-team-content-v3 .beautypress-btn.small-round-btn span' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                            'style' => ['style3','style4']
                ],
            ]
        );

        $this->add_control(
            'member_bg_hover_color',
            [
                'label'     => __( 'Backgound Overlay Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-team.beautypress-purple-overlay:after' => 'background-image:-webkit-linear-gradient( 90deg, rgb(211,16,39) 0%, {{VALUE}} 0%, rgba(255,255,255,0) 100%);',
                    '{{WRAPPER}} .beautypress-single-team.beautypress-version-2:after' => 'background-color:{{VALUE}};',
                ],
                'condition' => [
                    'style' => ['style1','style2']
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'member_hover_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-single-team:hover h3, {{WRAPPER}} .beautypress-single-team:hover h4, {{WRAPPER}} .beautypress-single-team p',
                'condition' => [
                    'style' => ['style1','style2']
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
    }

    protected function render( ) {

        $settings = $this->get_settings();

        // echo '<pre>';
        // print_r($settings);
        // echo '</pre>';

        $style = $settings['style'];

        $member_name = $settings['member_name'];

        $member_position = $settings['member_position'];

        $member_details = $settings['member_details'];

        $btn_label = $settings['btn_label'];

        $btn_link = $settings['btn_link'];

        $btn_target = ( $settings['btn_link']['is_external']) ? '_blank' : '_self';

        $member_image = $settings['member_image'];

        $member_show_social = $settings['member_show_social'];

        //$member_social = $settings['member_social'];

        $team_members = $settings['team_members'];

        switch ($style) {
            case 'style1':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/team/style1.php');
                break;

            case 'style2':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/team/style2.php');
                break;

            case 'style3':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/team/style3.php');
                break;

            case 'style4':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/team/style4.php');
                break;
        }

    }



    protected function content_template() { }
}