<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Slider_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-slider';
    }

    public function get_title() {
        return __( 'Beautypress Slider', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Slider', 'beautypress'),
            ]
        );

        $this->add_control(

            'style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                    'style3' => __('Style 3', 'beautypress'),
                ],
            ]
        );

        $this->add_control(
            'width',
            [
                'label' => __( 'Container Width', 'beautypress' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => '',
                ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['%' ],
                'selectors' => [
                    '{{WRAPPER}} .beautypress-welcome-container' => 'width: {{SIZE}}%;',
                ],
            ]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'image', [
                'label'       => __('Image', 'beautypress'),
                'type'        => Controls_Manager::MEDIA,
                'default'     => [
                    'url'     => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
			]
		);

		$repeater->add_control(
			'title', [
                'label' => __('Title', 'beautypress'),
                'type'  => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'sub_title',
			[
                'label' => __('Sub Title', 'beautypress'),
                'type'  => Controls_Manager::TEXT,
			]
		);
		$repeater->add_control(
			'description',
			[
                'label' => __('Description', 'beautypress'),
                'type'  => Controls_Manager::TEXTAREA,
			]
		);
		$repeater->add_control(
			'alignment',
			[
                'label'         => __( 'Alignment', 'beautypress' ),
                'type'          => Controls_Manager::CHOOSE,
                'options'       => [
                    'left'      => [
                        'title' => __( 'Left', 'beautypress' ),
                        'icon'  => 'fas fa-align-left',
                    ],
                    'center'    => [
                        'title' => __( 'Center', 'beautypress' ),
                        'icon'  => 'fas fa-align-center',
                    ],
                    'right'     => [
                        'title' => __( 'Right', 'beautypress' ),
                        'icon'  => 'fas fa-align-right',
                    ],
                ],
			]
		);
		$repeater->add_control(
			'btn_label_one',
			[
                'label'       => __('Button Label', 'beautypress'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __('LEARN MORE', 'beautypress'),
			]
		);
		$repeater->add_control(
			'btn_link_one',
			[
                'label'       => __( 'Link', 'beautypress' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __('http://your-link.com','beautypress' ),
                'default'     => [
                    'url'     => '',
                ],
			]
		);
		$repeater->add_control(
			'btn_label_two',
			[
                'label'       => __('Button Label', 'beautypress'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'default'     => __('LEARN MORE', 'beautypress'),
			]
		);
		$repeater->add_control(
			'btn_link_two',
			[
                'label'       => __( 'Link', 'beautypress' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => __('http://your-link.com','beautypress' ),
                'default'     => [
                    'url'     => '',
                ],
			]
		);

		$this->add_control(
			'sliders',
			[
				'label'   => __( 'Slider', 'beautypress' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [
					[
                        'title'         => __('Add Title', 'beautypress'),
                        'sub_title'     => __('Add Sub Title', 'beautypress'),
                        'description'   => __('Allow our team of beauty specialists to help you prepare for your wedding and enhance your special.', 'beautypress'),
                        'btn_label_one' => __('Learn More', 'beautypress'),
                        'btn_label_two' => __('Learn More', 'beautypress'),
                    ],

                    [
                        'title'         => __('Add Title', 'beautypress'),
                        'sub_title'     => __('Add Sub Title', 'beautypress'),
                        'description'   => __('Allow our team of beauty specialists to help you prepare for your wedding and enhance your special.', 'beautypress'),
                        'btn_label_one' => __('Learn More', 'beautypress'),
                        'btn_label_two' => __('Learn More', 'beautypress'),

                    ],

                    [
                        'title'         => __('Add Title', 'beautypress'),
                        'sub_title'     => __('Add Sub Title', 'beautypress'),
                        'description'   => __('Allow our team of beauty specialists to help you prepare for your wedding and enhance your special.', 'beautypress'),
                        'btn_label_one' => __('Learn More', 'beautypress'),
                        'btn_label_two' => __('Learn More', 'beautypress'),

                    ],
				],
				'title_field' => '{{{ title }}}',
                'condition'   => [
                    'style'   => ['style1','style2'],
                ],
			]
		);

        $this->add_control(
          'images',
          [
            'label'         => esc_html__( 'Images', 'beautypress' ),
            'type'          => Controls_Manager::GALLERY,
            'condition'     =>  [
                'style' =>  ['style3']
            ],
          ]
        );

        $this->end_controls_section();

        //Title Style
        $this->start_controls_section(
            'section_slider_tab',
            [
                'label' => __('Slider Option', 'beautypress'),
            ]
        );
        $this->add_control(
            'xs_loop',
            [
                'label'         => __( 'Loop', 'marketo' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => __( 'Yes', 'marketo' ),
                'label_off'     => __( 'No', 'marketo' ),
                'default'       => 'true',
                'return_value'  =>  'true'
            ]
        );
        $this->add_control(
            'xs_autoplay',
            [
                'label'         => __( 'Auto Play', 'marketo' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => __( 'Yes', 'marketo' ),
                'label_off'     => __( 'No', 'marketo' ),
                'default'       => 'true',
                'return_value'  =>  'true'
            ]
        );

        $this->add_control(
            'xs_nav',
            [
                'label'         => __( 'Show Nav', 'marketo' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => __( 'Yes', 'marketo' ),
                'label_off'     => __( 'No', 'marketo' ),
                'default'       => 'true',
                'return_value'  =>  'true'
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section_title_style',
            [
                'label'     => __( 'Title', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-welcome-wraper h2' => 'color: {{VALUE}} !important;'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-welcome-wraper h2',
            ]
        );

        $this->add_control(
            'margin_bottom',
            [
                'label' => __( 'Margin Bottom', 'beautypress' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => '',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .beautypress-welcome-wraper h2' => 'margin-bottom: {{SIZE}}px;',
                ],
                'condition' => [
                    'style'   =>  ['style1'],
                ],
            ]
        );

        $this->add_control(
            'bg_main_color',
            [
                'label'     => __( 'Background Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-image-slider .owl-stage-outer:before' => '    background-color: {{VALUE}};',
                ],
                'condition' => [
                    'style' => ['style3']
                ],
            ]
        );

        $this->end_controls_section();

        //Sub Title Style

        $this->start_controls_section(
            'section_sub_style',
            [
                'label'     => __( 'Sub Title', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'sub_title_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-welcome-wraper h3' => 'color: {{VALUE}} !important;'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-welcome-wraper h3',
            ]
        );

        $this->end_controls_section();

        //Decription Style

        $this->start_controls_section(
            'section_desc_style',
            [
                'label'     => __( 'Description', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-welcome-wraper p' => 'color: {{VALUE}} !important;'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-welcome-wraper p',
            ]
        );

        $this->end_controls_section();

        //Button Style One
        $this->start_controls_section(
            'section_btn_style',
            [
                'label'     => __( 'Button One', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} a.beautypress-btn.bg-color-pink' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_hover_color',
            [
                'label' => __( 'Hover Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} a.beautypress-btn.bg-color-pink:hover' => 'color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'btn_bg_color',
            [
                'label' => __( 'Background Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                   '{{WRAPPER}} a.beautypress-btn.bg-color-pink' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_hover_color',
            [
                'label' => __( 'Background Hover Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                  '{{WRAPPER}} a.beautypress-btn.bg-color-pink span' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();

         //Button Style Two
        $this->start_controls_section(
            'section_btn_two_style',
            [
                'label'     => __( 'Button Two', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'btn_two_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} a.beautypress-btn.bg-color-purple ' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_two_hover_color',
            [
                'label' => __( 'Hover Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} a.beautypress-btn.bg-color-purple:hover' => 'color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'btn_two_bg_color',
            [
                'label' => __( 'Background Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                   '{{WRAPPER}} a.beautypress-btn.bg-color-purple' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );
        $this->add_control(
            'btn_two_bg_hover_color',
            [
                'label' => __( 'Background Hover Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                  '{{WRAPPER}} a.beautypress-btn.bg-color-purple span' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();

        //Title Style

        $this->start_controls_section(
            'section_overlay_style',
            [
                'label'     => __( 'Overlay', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'slider_overlay_color',
            [
                'label'     => __( 'Overlay Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-black-gradient-overlay:before' => 'background-image: -webkit-linear-gradient( 175deg, rgba(236,85,152,0) 0%, {{VALUE}} 24%, {{VALUE}} 46%, {{VALUE}} 100%)',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();

        $sliders = $settings['sliders'];

        $images = $settings['images'];

        $style = $settings['style'];

        $slider_setting = array(
            'xs_loop' => $settings['xs_loop'],
            'xs_autoplay' => $settings['xs_autoplay'],
            'xs_loop' => $settings['xs_loop'],
            'xs_nav'    => $settings['xs_nav']
        );

        $slider_settings = json_encode( $slider_setting );
        switch ($style) {
            case 'style1':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/slider/style1.php');
                break;

            case 'style2':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/slider/style2.php');
                break;

            case 'style3':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/slider/style3.php');
                break;
        }

    }

    protected function content_template() { }
}
?>