<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Single_Image_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-single-image';
    }

    public function get_title() {
        return __( 'Beautypress Single Image', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-image-rollover';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Single Image', 'beautypress'),
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'beautypress' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );

        $this->add_group_control(
			\Xs_Group_Control_Image_Size::get_type(),
			[
				'name' => 'image',
				'label' => __( 'Image Size', 'beautypress' ),
				'default' => 'full',
			]
		);

		$this->add_control(
            'xs_effect',
            [
                'label'         => __( 'Active 3D Effect', 'beautypress' ),
                'type'          => Controls_Manager::SWITCHER,
                //'default'       => 'no',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
            ]
        );
        $this->add_control(
            'border_radius',
            [
                'label' => __( 'Border radius', 'beautypress' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'step' => 1,
                    ]
                ],
                'size_units' => [ 'px'],
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-image img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'alignment',
            [
                'label'     => __( 'Alignment', 'beautypress' ),
                'type'      => Controls_Manager::CHOOSE,
                'options'   => [
                    'left'      => [
                        'title' => __( 'Left', 'beautypress' ),
                        'icon'  => 'fas fa-align-left',
                    ],
                    'center'    => [
                        'title' => __( 'Center', 'beautypress' ),
                        'icon'  => 'fas fa-align-center',
                    ],
                    'right'     => [
                        'title' => __( 'Right', 'beautypress' ),
                        'icon'  => 'fas fa-align-right',
                    ],
                ],
                'prefix_class' => 'elementor%s-align-',
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();

        $effect = ($settings['xs_effect']) ? 'beautypress-3d-project-card' : 'beautypress-single-image';

        $effect_triger = ($settings['xs_effect']) ? 'beautypress-3d' : 'beautypress-single';

        ?>
		<div class="<?php echo esc_attr($effect_triger); ?> beautypress-single-image">
			<div class="<?php echo esc_attr($effect); ?>">
				<?php echo \Xs_Group_Control_Image_Size::get_attachment_image_html( $settings,'image'); ?>
			</div>
		</div>
        <?php
    }



    protected function content_template() { }
}
?>