<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Service_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-service';
    }

    public function get_title() {
        return __( 'Service Tab', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-tabs';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Service Tab', 'beautypress'),
            ]
        );
        $this->add_control(
            'beautypress_custom_category_enable',
            [
                'label' => esc_html__( 'Custom Category?', 'beautypress' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'beautypress' ),
                'label_off' => esc_html__( 'No', 'beautypress' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control('beautypress_custom_category_list',
            [
                'label'     => esc_html__( 'Select categories', 'beautypress' ),
                'type'      => \Elementor\Controls_Manager::SELECT2,
                'multiple'  => true,
                'default'   => '',
                'options'   => $this->getCategories(),
                'condition' => [
                        'beautypress_custom_category_enable' => 'yes'
                ]

            ]
        );
        $this->add_control(

            'service_heading', [
                'type' => Controls_Manager::HEADING,
               'label' => __('Goto Admin Panel And Click To Service Tab Menu For edit This Post','beautypress'),
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings =  $this->get_settings();

        extract($settings);
    ?>
        <div class="beautypress-tab">
            <div class="tabbable">
                <?php
                     $service_cat = array(
                        'orderby'       => 'ID',
                        'order'         => 'DESC', 
                        'hide_empty'    => 1,
                        'hierarchical'  => 1,
                        'taxonomy'      => 'service_cat',
                    );

                    $selected_catagory = get_terms( array(
                        'taxonomy'    => 'service_cat',
                        'hide_empty'  => 1,
                        'posts_per_page' => -1,
                        'include'        => $beautypress_custom_category_list
                    ) );


                   if($beautypress_custom_category_enable == 'yes') {
                       $categories = $selected_catagory;
                   }else{
                       $categories = get_categories( $service_cat);
                   }

                    
                    if(is_array($categories) && count($categories) > 0):
                        ?>
                        <ul class="nav nav-tabs beautypress-top-nav">
                            <?php 
                                foreach($categories as $key => $category): 
                                    $active = ($key == 0) ? 'active' : '';
                                    $data = get_term_meta( $category->term_id, '_service_cat', true );
                                    $data = maybe_unserialize($data);
                                    $service_icon = isset($data['service_cat_icon']) ? $data['service_cat_icon'] : '';
                            ?>
                                    <li class="<?php echo esc_attr($active) ?>"><a href="#<?php echo esc_attr($category->slug) ?>" data-toggle="tab"><i class="<?php echo esc_attr($service_icon) ?>"></i><span><?php echo esc_html($category->name) ?></span></a></li>
                            <?php 
                                endforeach; 
                            ?>
                        </ul>
                        <div class="tab-content">
                            <?php
                                $count_posts = wp_count_posts('service'); 
                                foreach($categories as $key => $category):
                                    $active = ($key == 0) ? 'active' : '';
                                    $query = array(
                                        'post_type'      => 'service',
                                        'post_status'    => 'publish',
                                        'posts_per_page' => -1,
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'service_cat',
                                                'field' => 'slug',
                                                'terms' => $category->slug
                                            )
                                        )
                                    );
                                    $xs_query = new \WP_Query($query);
                                    $tabs_id = uniqid('xs-tabs-').mt_rand(1000,9999);
                                    echo '<div class="tab-pane '.esc_attr($active).'" id="'.esc_attr($category->slug).'">';
                                             echo '<div class="tabbable">';
                                                echo '<ul class="nav nav-tabs beautypress-side-nav">';
                                                    $j = 1;
                                                    while ($xs_query->have_posts()) : 
                                                        $active = ($j == 1) ? 'active' : '';
                                                        $xs_query->the_post();
                                                        echo  '<li class="'.esc_attr($active).'"><a href="#'.esc_attr($tabs_id.$j).'" data-toggle="tab">'.get_the_title().'</a></li>';
                                                        $j++;
                                                    endwhile;
                                                    wp_reset_postdata();
                                                echo '</ul><div class="tab-content">';
                                            $i = 1;
                                            while ($xs_query->have_posts()) : 
                                                $active = ($i == 1) ? 'active' : '';
                                                $xs_query->the_post();
                                                $service_image = xs_post_get_meta(get_the_ID(),'_service_meta', 'service_image','');
                                                $img = \xs_resize( $service_image, 348, 404 );
                                                $price = xs_post_get_meta(get_the_ID(),'_service_meta', 'service_price','');
                                                $content = xs_post_get_meta(get_the_ID(),'_service_meta', 'service_content','');
                                                $btn_lable = xs_post_get_meta(get_the_ID(),'_service_meta', 'service_btn_lable','');
                                                $btn_link = xs_post_get_meta(get_the_ID(),'_service_meta', 'service_btn_link','');
                                                $btn_target = xs_post_get_meta(get_the_ID(),'_service_meta', 'service_link_target','');
                                                ?> 
                                                    <div class="tab-pane beautypress-tab-content <?php echo esc_attr($active) ?>" id="<?php echo esc_attr($tabs_id.$i); ?>">
                                                        <div class="beautypress-spilit-container">
                                                            <?php if($img != ''): ?>
                                                                <div class="beautypress-tab-image">
                                                                    <img src="<?php echo esc_url($img) ?>" alt="<?php echo get_the_title(); ?>">
                                                                    <div class="beautypress-tab-image-content">
                                                                        <span class="beautypress-iocn-btn full-round-btn bg-color-purple"><?php echo esc_html($price) ?></span>
                                                                    </div>
                                                                </div>
                                                            <?php endif; ?>
                                                            <div class="beautypress-tab-text-content">
                                                                <h3><?php the_title(); ?></h3>
                                                                <?php echo wp_kses_post( $content ); ?>
                                                                <div class="beautypress-btn-wraper">
                                                                    <a href="<?php echo esc_url($btn_link) ?>" target="<?php echo esc_html($btn_target) ?>" class="beautypress-btn xs-btn round-btn box-shadow-btn bg-color-purple"><?php echo esc_html($btn_lable) ?><span></span></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php
                                            $i++;
                                            endwhile;
                                            wp_reset_postdata();
                                            echo '</div></div>';
                                        echo '</div>';
                                endforeach;
                            ?>
                        </div>
                        <?php
                    endif;
                ?>
            </div>
        </div>
    <?php    
    }



    protected function content_template() { }

    public function getCategories(){
        $terms = get_terms( array(
            'taxonomy'    => 'service_cat',
            'hide_empty'  => false,
            'posts_per_page' => -1,
        ) );


        $cat_list = [];
        if(is_array($terms) && '' != $terms) :
            foreach($terms as $post) {

                $cat_list[$post->term_id]  = [$post->name];
            }
        endif;
        return $cat_list;
    }
}