<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Schedule_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-schedule';
    }

    public function get_title() {
        return __( 'Beautypress Schedule', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-calendar';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Schedule', 'beautypress'),
            ]
        );

        $this->add_control(

            'style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'beautypress' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __( 'Add title', 'beautypress' ),
                'default' => __( 'Add Title', 'beautypress' ),
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => __( 'Sub Title', 'beautypress' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __( 'Description', 'beautypress' ),
                'default' => __( 'Description', 'beautypress' ),
                'condition' =>  [
                    'style' => ['style1']
                ],
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __( 'Description', 'beautypress' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'placeholder' => __( 'Description', 'beautypress' ),
                'default' => __( 'Description', 'beautypress' ),
                'condition' =>  [
                    'style' => ['style1']
                ],
            ]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'schedule_label', [
                'label' => __('Label', 'beautypress'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'schedule_value', [
                'label' => __('value', 'beautypress'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
			]
		);

		$repeater->add_control(
			'is_weekend',
			[
                'label' => __('Is Weekend', 'beautypress'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'beautypress' ),
                'label_off' => __( 'No', 'beautypress' ),
                'return_value' => 'xs-weekend',
			]
		);

		$this->add_control(
			'schedule',
            [
                'label' => __('Schedule', 'beautypress'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'separator' => 'before',
                'default' => [
                    [
                        'schedule_label' => __('Schedule Label #1', 'beautypress'),
                        'schedule_value' => __('Schedule value', 'beautypress'),
                        'is_weekend'    => '',
                    ],

                    [
                        'schedule_label' => __('Schedule Label #1', 'beautypress'),
                        'schedule_value' => __('Schedule value', 'beautypress'),
                        'is_weekend'    => '',
                    ],

                    [
                        'schedule_label' => __('Schedule Label #1', 'beautypress'),
                        'schedule_value' => __('Schedule value', 'beautypress'),
                        'is_weekend'    => '',
                    ],
                ],
				'title_field' => '{{{ schedule_label }}}',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'section_title_style',
			[
				'label' 	=> __( 'Title', 'beautypress' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'title_color',
			[
				'label'		=> __( 'Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-booking-text h2' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_typography',
                'selector'     => '{{WRAPPER}} .beautypress-booking-text h2',
            ]
        );

		$this->end_controls_section();

		/**
		 *
		 * Sub Title
		 *
		 */

		$this->start_controls_section(
			'section_sub_style',
			[
				'label' 	=> __( 'Sub Title', 'beautypress' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'sub_title_color',
			[
				'label'		=> __( 'Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-booking-text h3' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'sub_title_typography',
                'selector'     => '{{WRAPPER}} .beautypress-booking-text h3',
            ]
        );

		$this->end_controls_section();

		/**
		 *
		 * Description
		 *
		 */
		$this->start_controls_section(
			'section_desc_style',
			[
				'label' 	=> __( 'Description', 'beautypress' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'desc_color',
			[
				'label'		=> __( 'Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-icon-bg-text p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'desc_typography',
                'selector'     => '{{WRAPPER}} .beautypress-icon-bg-text p',
            ]
        );

		$this->end_controls_section();

		/**
		 *
		 * Schedule
		 *
		 */
		$this->start_controls_section(
			'section_schedule_style',
			[
				'label' 	=> __( 'Schedule', 'beautypress' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'schedule_color',
			[
				'label'		=> __( 'Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-booking-text ul li' => 'color: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'weekend_color',
            [
                'label'     => __( 'Weekend Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-booking-text ul li.xs-weekend' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

		$this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'schedule_typography',
                'selector'     => '{{WRAPPER}} .beautypress-booking-text ul li',
            ]
        );

		$this->end_controls_section();

        /**
         *
         * Icon Section
         *
         */
        $this->start_controls_section(
            'section_icon_style',
            [
                'label'     => __( 'Icon', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'schedule_icon_color',
            [
                'label'     => __( 'Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-icon-bg-text:before' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Border Section
         *
         */
        $this->start_controls_section(
            'section_border_style',
            [
                'label'     => __( 'Border', 'beautypress' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'schedule_border_color',
            [
                'label'     => __( 'Color', 'beautypress' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-border.beautypress-version-3, .beautypress-border.beautypress-version-3:before, .beautypress-border.beautypress-version-3:after' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        $style = $settings['style'];

        $title = $settings['title'];

        $sub_title = $settings['sub_title'];

        $description = $settings['description'];

        $schedule = $settings['schedule'];

        switch ($style) {
            case 'style1':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/schedule/style1.php');
                break;

            case 'style2':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/schedule/style2.php');
                break;
        }
    }



    protected function content_template() { }
}