<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class XS_Price_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-price';
    }

    public function get_title() {
        return __( 'BeautyPress Price Table', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-price-table';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Price Table', 'beautypress'),
            ]
        );

        $this->add_control(

            'price_style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                    'style3' => __('Style 3', 'beautypress'),
                    'style4' => __('Style 4', 'beautypress'),
                    'style5' => __('Style 5', 'beautypress'),
                ],
            ]
        );

        $this->add_control(
			'pricing_image',
			[
			     'label' => __( 'Choose Image', 'beautypress' ),
			     'type' => Controls_Manager::MEDIA,
			     'default' => [
			        'url' => Utils::get_placeholder_image_src(),
			     ],
			     'condition' => [
                    'price_style'   =>  ['style1','style2','style4','style5'],
                ],
			]
		);

		$this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'beautypress' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
                'default' => 'xsicon icon-soap',
                'condition' => [
                    'price_style'   =>  ['style3'],
                ],

            ]
        );

		$this->add_control(
			'pricing_plan_title',
			[
			     'label' => __( 'Price Plan Title', 'beautypress' ),
			     'type' => Controls_Manager::TEXT,
			     'label_block' => true,
			     'default'	=> __('Hair Cut','beautypress'),
			]
		);

		$this->add_control(
			'pricing_plan_tag',
			[
			     'label' => __( 'Price Tag Line', 'beautypress' ),
			     'type' => Controls_Manager::TEXT,
			     'label_block' => true,
			     'default'	=> __('Start From','beautypress'),
			     'description' => __('Provide any subtitle or taglines like "Start From", "Best Value", "Best Selling", "Most Flexible" etc.', 'beautypress'),
			     'condition' => [
	                'price_style' => ['style1','style3','style4','style5']
	            ],
			]
		);

		$this->add_control(
			'pricing_plan_currency',
			[
			     'label' => __( 'Currency', 'beautypress' ),
			     'type' => Controls_Manager::TEXT,
			     'label_block' => true,
			     'default'	=> __('$','beautypress'),
			     'description' => __('Enter the price Currency.','beautypress'),
			     'condition' => [
	                'price_style' => ['style1','style3','style4','style5']
	            ],
			]
		);

		$this->add_control(
			'pricing_plan_price',
			[
			     'label' => __( 'Price', 'beautypress' ),
			     'type' => Controls_Manager::TEXT,
			     'label_block' => true,
			     'default'	=> __('50','beautypress'),
			     'description' => __('Enter the price tag for the pricing plan.','beautypress'),
			     'condition' => [
	                'price_style' => ['style1','style3','style4','style5']
	            ],
			]
		);

		$this->add_control(

			'pricing_btn_text',
			[
				'type' => Controls_Manager::TEXT,
                'label' => __('Button Lable', 'beautypress'),
                'label_block' => true,
                'default'	=> __('Appointment Now','beautypress'),
                'condition' => [
	                'price_style' => ['style1','style3','style4','style5']
	            ],
			]
		);

		$this->add_control(
			'pricing_btn_link',
			[
                'name' => 'button_url',
                'label' => __('Button Url', 'beautypress'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [
                    'url' => '',
                    'is_external' => 'true',
                ],
                'placeholder' => __('http://your-link.com', 'beautypress'),
                'condition' => [
	                'price_style' => ['style1','style3','style4','style5']
	            ],
            ]
		);

		$this->add_control(
            'pricing_heading',
            [
                'label' => __('Pricing Plans Content', 'beautypress'),
                'type' => Controls_Manager::HEADING,
            ]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'pricing_title', [
				'type' => Controls_Manager::TEXT,
				'label' => __('Pricing Title', 'beautypress'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'pricing_tag', [
				'type' => Controls_Manager::TEXT,
				'label' => __('Pricing Amount', 'beautypress'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'pricing_content',
			[
				'label' => __( 'Repeater List', 'plugin-domain' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'pricing_title' => __("Teen's haircut", 'beautypress'),
                        'pricing_tag' => __('50', 'beautypress'),
					],
					[
						'pricing_title' => __("Men's haircut", 'beautypress'),
                        'pricing_tag' => __('50', 'beautypress'),
					],
					[
						'pricing_title' => __("Children's haircut", 'beautypress'),
                        'pricing_tag' => __('50', 'beautypress'),
					],
				],
				'title_field' => '{{{ pricing_title }}}',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'section_title_style',
			[
				'label' 	=> __( 'Style', 'beautypress' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'bg_main_color',
			[
				'label'		=> __( 'Background Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-pricing-table' => '    background-color: {{VALUE}} !important;',
				],
				'condition' => [
	                'price_style' => ['style3']
	            ],
			]
		);

        $this->add_control(
			'bg_overlay_color',
			[
				'label'		=> __( 'BG Overlay Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-purple-overlay:before' => 'background-image: -webkit-linear-gradient( 90deg, {{VALUE}} 0%, rgba(255,255,255,0) 100%);',
					//'{{WRAPPER}} .beautypress-single-pricing-table' => 'background-color:{{VALUE}};',
				],
			]
		);

		$this->add_control(
			'price_title_color',
			[
				'label'		=> __( 'Price Title Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-pricing-title h2' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'price_color',
			[
				'label'		=> __( 'Price Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-pricing-price h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'price_tag_color',
			[
				'label'		=> __( 'Price Tag Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-pricing-price h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'price_content_color',
			[
				'label'		=> __( 'Pricing Content Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} ul.beautypress-both-side-list li' => 'color: {{VALUE}};',
					'{{WRAPPER}} ul.beautypress-both-side-list li span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'price_content_bg',
			[
				'label'		=> __( 'Pricing Content BG Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-pricing-footer' => 'background-color: {{VALUE}};'
				],
			]
		);

		$this->add_control(
			'price_btn_color',
			[
				'label'		=> __( 'Button Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-btn' => 'color: {{VALUE}};',
				]
			]
		);

		$this->add_control(
			'btn_hover_color',
			[
				'label'		=> __( 'Button Hover Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-btn:hover' => 'color: {{VALUE}} !important;'
				],
			]
		);

		$this->add_control(
			'price_btn_bg',
			[
				'label'		=> __( 'Button BG Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-btn' => 'background-color: {{VALUE}} !important;'
				],
			]
		);

		$this->add_control(
			'btn_hover_bg',
			[
				'label'		=> __( 'Button Hover BG Color', 'beautypress' ),
				'type'		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.beautypress-btn.bg-color-purple span' => 'background-color: {{VALUE}};'
				],
			]
		);

		$this->end_controls_section();
    }

    protected function render( ) {
          	$settings = $this->get_settings();
	        $style = $settings['price_style'];

	        switch ($style) {

	        	case 'style1':

	        		$pricing_image = $settings['pricing_image'];
			        $pricing_plan_title = $settings['pricing_plan_title'];
			        $pricing_plan_tag = $settings['pricing_plan_tag'];
			        $pricing_plan_currency = $settings['pricing_plan_currency'];
			        $pricing_plan_price = $settings['pricing_plan_price'];
			        $pricing_btn_text = $settings['pricing_btn_text'];
			        $pricing_btn_link = $settings['pricing_btn_link']['url'];
			        $target = ($settings['pricing_btn_link']['is_external']) ? $target = '_blank' : '_self';
			        $pricing_content = $settings['pricing_content'];

			        include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/price-table/style1.php');
	        		break;

	        	case 'style2':

	        		$pricing_image = $settings['pricing_image'];
			        $pricing_plan_title = $settings['pricing_plan_title'];
			        $pricing_content = $settings['pricing_content'];

	        		include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/price-table/style2.php');
	        		break;

	        	case 'style3':

	        		$icon = $settings['icon'];

			        $pricing_plan_title = $settings['pricing_plan_title'];
			        $pricing_plan_tag = $settings['pricing_plan_tag'];
			        $pricing_plan_currency = $settings['pricing_plan_currency'];
			        $pricing_plan_price = $settings['pricing_plan_price'];
			        $pricing_btn_text = $settings['pricing_btn_text'];
			        $pricing_btn_link = $settings['pricing_btn_link']['url'];
			        $target = ($settings['pricing_btn_link']['is_external']) ? $target = '_blank' : '_self';
			        $pricing_content = $settings['pricing_content'];

			        include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/price-table/style3.php');

	        		break;

	        	case 'style4':

	        		$pricing_image = $settings['pricing_image'];
			        $pricing_plan_title = $settings['pricing_plan_title'];
			        $pricing_plan_tag = $settings['pricing_plan_tag'];
			        $pricing_plan_currency = $settings['pricing_plan_currency'];
			        $pricing_plan_price = $settings['pricing_plan_price'];
			        $pricing_btn_text = $settings['pricing_btn_text'];
			        $pricing_btn_link = $settings['pricing_btn_link']['url'];
			        $target = ($settings['pricing_btn_link']['is_external']) ? $target = '_blank' : '_self';
			        $pricing_content = $settings['pricing_content'];

			        include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/price-table/style4.php');

	        		break;

	        	case 'style5':

	        		$pricing_image = $settings['pricing_image'];
			        $pricing_plan_title = $settings['pricing_plan_title'];
			        $pricing_plan_tag = $settings['pricing_plan_tag'];
			        $pricing_plan_currency = $settings['pricing_plan_currency'];
			        $pricing_plan_price = $settings['pricing_plan_price'];
			        $pricing_btn_text = $settings['pricing_btn_text'];
			        $pricing_btn_link = $settings['pricing_btn_link']['url'];
			        $target = ($settings['pricing_btn_link']['is_external']) ? $target = '_blank' : '_self';
			        $pricing_content = $settings['pricing_content'];

			        include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/price-table/style5.php');

	        		break;
	        }

          	?>
          <?php
    }


    protected function content_template() { }
}