<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Post_Widget extends Widget_Base {

  public $base;

    public function get_name() {
        return 'xs-blog';
    }

    public function get_title() {
        return esc_html__( 'Post', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post', 'beautypress'),
            ]
        );

        $this->add_control(
          'post_count',
          [
            'label'         => esc_html__( 'Post count', 'beautypress' ),
            'type'          => Controls_Manager::NUMBER,
            'default'       => esc_html__( '3', 'beautypress' ),

          ]
        );
        
        $this->add_control(
            'count_col',
            [
                'label'     => esc_html__( 'Select Column', 'beautypress' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 4,
                'options'   => [
                        '6'     => esc_html__( '2 Column', 'beautypress' ),
                        '4'     => esc_html__( '3 Column', 'beautypress' ),
                        '3'     => esc_html__( '4 Column', 'beautypress' ),
                    ],
            ]
        );
        
        $this->add_control(
          'xs_post_cat',
          [
             'label'    => __( 'Select category', 'beautypress' ),
             'type'     => Controls_Manager::SELECT,
             'options'  => xs_category_list( 'category' ),
             'default'  => '0'
          ]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
          $settings = $this->get_settings();
          $xs_post_cat = $settings['xs_post_cat'];
          $count_col = $settings['count_col'];
          $post_count = $settings['post_count'];
           

          $query = array(
              'post_type'      => 'post',
              'post_status'    => 'publish',
              'posts_per_page' => $post_count,
              'cat' => $xs_post_cat,
          );
          $xs_query = new \WP_Query($query);
          if($xs_query->have_posts()):
          ?>
              <div class="row">
                <?php
                $i = 1;
                while ($xs_query->have_posts()) : 
                    $xs_query->the_post();
                    $time = strtotime(get_the_date('',get_the_ID()));
                    $date = date('d',$time);
                    $month = date('M',$time);
                    ?>
                    <div class="col-sm-6 col-md-<?php echo esc_attr($count_col);?>">
                        <div class="beautypress-single-newsletter">
                            <div class="beautypress-newsfeed-header <?php echo ($i % 2 == 0 ) ? 'beautypress-pink-overlay' : 'beautypress-purple-overlay'; ?> beautypress-light-overlay">
                                <?php 
                                  if(has_post_thumbnail()):
                                    $img = \xs_resize( get_post_thumbnail_id( $xs_query->ID ), 350, 218 );
                                ?>
                                  <img src="<?php echo esc_url($img); ?>" alt="<?php echo get_the_title(); ?>">
                                <?php endif; ?>
                                <div class="beautypress-newsfeed-header-content">
                                  <div class="beautypress-newsfeed-img">
                                    <?php echo get_avatar(get_the_author_meta( 'ID' ), 50 );?>
                                    <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a>
                                  </div>
                                  <div class="beautypress-dates">
                                    <p class="bg-color-purple" ><?php echo esc_html( get_the_date('d') );?><strong><?php echo esc_html( get_the_date('M') );?></strong></p>
                                  </div>
                                </div>
                            </div>
                            <div class="beautypress-newsfeed-footer">
                              <a href="<?php echo get_the_permalink(); ?>"><?php the_title() ?></a>
                              <?php echo wp_kses_post(wp_trim_words(get_the_content(),15,'')) ?>
                            </div>
                        </div>
                    </div>
                    <?php
                    $i++;
                endwhile;
                ?>
              </div>
            <?php
          endif;
          wp_reset_postdata();
    }



    protected function content_template() { }
}