<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Portfolio_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-portfolio';
    }

    public function get_title() {
        return __( 'Beautypress Portfolio', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-gallery-masonry';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Portfolio', 'beautypress'),
            ]
        );

        $this->add_control(

            'style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Grid', 'beautypress'),
                    'style2' => __('masonry', 'beautypress'),
                ],
            ]
        );
    
		$this->add_control(
	      'post_count',
	      [
	        'label'         => esc_html__( 'Post count', 'beautypress' ),
	        'type'          => Controls_Manager::NUMBER,
	        'default'       => 12,
	      ]
	    );
	    
	    $this->add_control(
	        'count_col',
	        [
	            'label'     => esc_html__( 'Grid Per row', 'beautypress' ),
	            'type'      => Controls_Manager::SELECT,
	            'default'   => 3,
	            'options'   => [
	                    '3'     => esc_html__( '3 Column', 'beautypress' ),
	                    '4'     => esc_html__( '4 Column', 'beautypress' ),
	            ],
                'condition'     =>  [
                    'style' =>  'style1',
                ],
	        ]
	    );

	    $this->add_control(
            'xs_effect',
            [
                'label'         => __( 'Active 3D Effect', 'beautypress' ),
                'type'          => Controls_Manager::SWITCHER,
                //'default'       => 'no',
                //'return_value'	=> 'beautypress-3d',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
            ]
        );

	    $this->add_control(
            'filter_show',
            [
                'label'         => __( 'Show Filter', 'beautypress' ),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'yes',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
            'section_genarel_styling',
            [
                'label' => __('General Setting', 'beautypress'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
            'gutter',
            [
                'label' => __('Gutter', 'beautypress'),
                'description' => __('Space between columns in the grid.', 'beautypress'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .beautypress-photo-gallery-grid-v3-item' => 'padding: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .beautypress-photo-gallery-grid-item' => 'padding: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bg_overlay_color',
            [
                'label' => __( 'Background Overlay Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-photo-gallery .beautypress-gallery-overlay' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
            'section_filters_styling',
            [
                'label' => __('Filters', 'beautypress'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'filter_color',
            [
                'label' => __( 'Filter Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-portfolio-nav ul li a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_hover_color',
            [
                'label' => __( 'Filter Hover Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-portfolio-nav ul li a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_border_color',
            [
                'label' => __( 'Filter Border Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-portfolio-nav ul li a:before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_active_border',
            [
                'label' => __( 'Active Filter Border Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-portfolio-nav ul li a.selected:before ' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'filter_typography',
                'selector' => '{{WRAPPER}} .beautypress-portfolio-nav ul li a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_icon_styling',
            [
                'label' => __('Icon', 'beautypress'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'popup_icon_color',
            [
                'label' => __( 'Popup image Icon Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-photo-gallery .beautypress-iocn-btn.full-round-btn.bg-color-cyan' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'popup_icon_bg_color',
            [
                'label' => __( 'Popup image BG Icon Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-photo-gallery .beautypress-iocn-btn.full-round-btn.bg-color-cyan' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'link_icon_color',
            [
                'label' => __( 'Link Icon Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-photo-gallery .beautypress-iocn-btn.full-round-btn.bg-chocolate' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_icon_bg_color',
            [
                'label' => __( 'Link Icon BG Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-photo-gallery .beautypress-iocn-btn.full-round-btn.bg-chocolate' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
	}
    protected function render( ) {

        $settings = $this->get_settings();

        $count_col = ($settings['count_col'] == 3 ) ? 'beautypress-photo-gallery-grid' : 'beautypress-photo-gallery-grid-v3';

        $post_count = $settings['post_count'];

        $filter_show = $settings['filter_show'];

        $effect = ($settings['xs_effect']) ? 'beautypress-3d-project-card' : '';

        $effect_triger = ($settings['xs_effect']) ? 'beautypress-3d' : '';

		$filter_cat = array(
            'orderby'       => 'ID',
            'order'         => 'DESC', 
            'hide_empty'    => 1,
            'hierarchical'  => 1,
            'taxonomy'      => 'portfolio_cat'
        );

        $categories = get_categories( $filter_cat );

    	$query = array(
            'post_type'      => 'xs-portfolio',
            'post_status'    => 'publish',
            'posts_per_page' => $post_count,
    	);

    	$xs_query = new \WP_Query($query);

        ?>
        <div class="beautypress-photo-gallery-wraper">
        	<?php if(is_array($categories) && count($categories) > 0 && ($filter_show)): ?>
				<div class="beautypress-portfolio-nav beautypress-version portfolio-menu">
					<ul id="filters" class="option-set clearfix" data-option-key="filter">
						<li><a href="#" data-option-value="*" class="selected"><?php echo __( 'All item', 'beautypress' ) ?></a></li>
						<?php foreach($categories as $xs_cat): ?>
							<li><a href="#" data-option-value=".<?php echo esc_attr($xs_cat->slug); ?>"><?php echo esc_html($xs_cat->name); ?></a></li>
						<?php endforeach; ?>
					</ul>
				</div>
			<?php endif; ?>
            <?php
                $key = 0;
                $large_counter = 1;
                $next_number_to_add = 4;
                $next_trigger = 1;
            ?>
			<?php if($xs_query->have_posts()): ?>
					<div class="<?php echo esc_attr($count_col); ?>">
						<?php 
						while ($xs_query->have_posts()) :
							$xs_query->the_post();

                            $large_counter_trigger = FALSE;
                            $wrapper_class = '';
                            if($next_trigger == $key+1)
                            {
                                $large_counter_trigger = TRUE;
                                $next_trigger = $next_trigger+$next_number_to_add;
                                
                                if($next_number_to_add == 4)
                                {
                                    $next_number_to_add = 2;
                                }
                                else if($next_number_to_add==2)
                                {
                                    $next_number_to_add = 4;
                                }
                            }
                            if($large_counter_trigger)
                            {
                                $wrapper_class = 'double_size';
                            }
                            
                            $large_counter++;
                            $key++;

                            
							$terms = get_the_terms(get_the_ID(), 'portfolio_cat');

                            $featured_image_size = xs_post_get_meta(get_the_ID(),'_folio_meta','featured_image_size','image_one');

                            $featured_image = xs_post_get_meta(get_the_ID(),'_folio_meta', 'featured_image','');

                            switch ($featured_image_size) {
                                case 'image_one':
                                    $width = 340;
                                    $height = 487;
                                    break;

                                case 'image_two':
                                    $width = 340;
                                    $height = 230;
                                    break;

                                case 'image_three':
                                    $width = 340;
                                    $height = 340;
                                    break;

                                case 'image_four':
                                    $width = 710;
                                    $height = 295;
                                    break;
                            }

							$filtering_slug = '';

							if ( $terms && ! is_wp_error($terms)) : 
						    	$filtering_slugs = array();
							    foreach ( $terms as $term ) {
							        $filtering_slugs[] = $term->slug;
							    }                
						    	$filtering_slug = join(" ", $filtering_slugs);
							endif;

                            $style = $settings['style'];
							switch ($style) {

                                case 'style1':
                                    if(!empty($featured_image)){
                                        $img = \xs_resize( $featured_image, 705, 529 );
                                        $img_popup =( wp_get_attachment_image_src($featured_image , 'full'));
                                        $img_popup =$img_popup[0];
                                    }else{

                                        $img = '';
                                        $img_popup = '';
                                    }
                                    include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/portfolio/style1.php');
                                    break;
                              
                                case 'style2':
                                    if(!empty($featured_image)){
                                        $img = \xs_resize( $featured_image, 721, 721 );
                                        $img_popup =( wp_get_attachment_image_src($featured_image , 'full'));
                                        $img_popup =$img_popup[0];
                                    }else{

                                        $img = '';
                                        $img_popup = '';
                                    }
                                    include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/portfolio/style2.php');
                                    break;
                            }
						endwhile; 
                        ?>
					</div>
			<?php endif; ?>
        </div>
        <?php
        wp_reset_postdata();
    }



    protected function content_template() { }
}
?>