<?PHP

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Partner_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-partner';
    }

    public function get_title() {
        return __( 'Beautypres Logo Carousel', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-carousel';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypres Logo Carousel', 'beautypress'),
            ]
        );

        $this->add_control(

            'style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                    'style3' => __('Style 3', 'beautypress'),
                ],
            ]
        );

        $this->add_control(
          'partner_image',
          [
            'label'         => esc_html__( 'Images', 'beautypress' ),
            'type'          => Controls_Manager::GALLERY,
            'description'    =>  __('You can use max six images','beautypress'),
            'condition'     =>  [
                'style' =>  'style1',
            ],
          ]
        );

        $this->add_control(
          'image',
          [
            'label'         => esc_html__( 'Images', 'beautypress' ),
            'type'          => Controls_Manager::GALLERY,
            'condition'     =>  [
                'style' =>  ['style2','style3']
            ],
          ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => __( 'Style', 'beautypress' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => __( 'Background Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-clients-wraper.no-slider .beautypress-clients-group .beautypress-single-client' => 'background-color: {{VALUE}};'
                ],
                'condition' =>  [
                    'style' =>  ['style2'],
                ],
            ]
        );

        $this->add_control(
            'background_hover_color',
            [
                'label' => __( 'Hover Background Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-clients-wraper.no-slider .beautypress-clients-group .beautypress-single-client:hover' => 'background-color: {{VALUE}};'
                ],
                'condition' =>  [
                    'style' =>  ['style2'],
                ],
            ]
        );

        $this->add_control(
            'nav_color',
            [
                'label' => __( 'Navigation Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .next-prev-btn.small-btn i' => 'color: {{VALUE}};'
                ],
                'condition' =>  [
                    'style' =>  ['style3'],
                ],
            ]
        );

        $this->add_control(
            'nav_bg_color',
            [
                'label' => __( 'Navigation BG Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .next-prev-btn.small-btn' => 'background-color: {{VALUE}};'
                ],
                'condition' =>  [
                    'style' =>  ['style3'],
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render( ) {
          $settings = $this->get_settings();

          $partner_image = $settings['partner_image'];

          $images = $settings['image'];

          $style = $settings['style'];

          switch ($style) {
                case 'style1':
                  include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/logo-carousel/style1.php');
                  break;
              
                case 'style2':
                  include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/logo-carousel/style2.php');
                  break;

                case 'style3':
                  include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/logo-carousel/style3.php');
                  break;
          }
    }

    protected function content_template() { }
}