<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Image_comparison_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-image-comparison';
    }

    public function get_title() {
        return __( 'Beautypress Image Comparison', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-image-before-after';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Image Comparison', 'beautypress'),
            ]
        );

        $this->add_control(
            'before_image',
            [
                'label' => __( 'Before Image', 'beautypress' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'after_image',
            [
                'label' => __( 'After Image', 'beautypress' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();
        ?>
		<div class='twentytwenty-container beautypress-before-after'>
			<?php echo \Xs_Group_Control_Image_Size::get_attachment_image_html( $settings,'after_image'); ?>
			<?php echo \Xs_Group_Control_Image_Size::get_attachment_image_html( $settings,'before_image'); ?>
		</div>
        <?php
    }



    protected function content_template() { }
}