<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class XS_Image_Box_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-image-box';
    }

    public function get_title() {
        return __( 'Beautypress Image Box', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-image-box';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Image Box', 'beautypress'),
            ]
        );

        $this->add_control(

            'style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                    'style3' => __('Style 3', 'beautypress'),
                    'style4' => __('Style 4', 'beautypress'),
                ],
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'beautypress' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );

        $this->add_group_control(
			\Xs_Group_Control_Image_Size::get_type(),
			[
				'name' => 'image',
				'label' => __( 'Image Size', 'beautypress' ),
				'default' => 'full',
			]
		);

        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'beautypress' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => 'xsicon icon-soap',
				'condition'	=>	[
                	'style'	=>	['style1','style2']
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'beautypress' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __( 'Add title', 'beautypress' ),
                'default' => __( 'Add Title', 'beautypress' ),
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __( 'Sub Title', 'beautypress' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => __( 'When an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries', 'beautypress' ),
                'condition'	=>	[
                	'style'	=>	['style2','style3']
                ]
            ]
        );

        $this->add_control(
            'btn_label',
            [
                'label' => __( 'Button Label', 'beautypress' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __( 'Read More', 'beautypress' ),
                'default' => __( 'Read More', 'beautypress' ),
                'condition'	=>	[
                	'style'	=>	['style1','style2','style3']
                ]
            ]
        );

        $this->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'beautypress' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __('http://your-link.com','beautypress' ),
				'default' => [
					'url' => '',
				],
			]
		);

        $this->end_controls_section();

        /**
		 *
		 *Title Style
		 *
		*/

        $this->start_controls_section(
			'section_title_tab',
			[
				'label' => __( 'Title', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-our-feature .beautypress-our-features-content h3 ' => 'color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-beauty-product-footer h3 ' => 'color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-service-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-popular-service-footer a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label' => __( 'Hover Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-popular-service-footer a:hover' => 'color: {{VALUE}};',
				],
				'condition'	=>	[
						'style'	=>	['style4'],
				],
			]
		);

		$this->add_control(
			'title_border_color',
			[
				'label' => __( 'Border Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-service-title:before' => 'background-color: {{VALUE}};',
				],
				'condition'	=>	[
					'style'	=>	['style3']
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'beautypress' ),
				'selector' => '{{WRAPPER}} .beautypress-single-our-feature .beautypress-our-features-content h3, 
				{{WRAPPER}} .beautypress-beauty-product-footer h3, 
				{{WRAPPER}} .beautypress-service-title,
				{{WRAPPER}} .beautypress-popular-service-footer a',
			]
		);

		$this->end_controls_section();


		/**
		 *
		 *Sub Title Style
		 *
		*/

        $this->start_controls_section(
			'section_sub_title_tab',
			[
				'label' => __( 'Sub Title', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'	=>	[
						'style'	=>	['style2','style3']
				],
			]
		);

		$this->add_control(
			'sub_title_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-beauty-product-footer p ' => 'color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-service-footer p ' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Typography', 'beautypress' ),
				'selector' => '{{WRAPPER}} .beautypress-beauty-product-footer p, {{WRAPPER}} .beautypress-service-footer p',
			]
		);

		$this->end_controls_section();


		/**
		 *
		 *Border Style
		 *
		*/

        $this->start_controls_section(
			'section_border_tab',
			[
				'label' => __( 'Border', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'	=>	[
					'style'	=>	'style2'
				],
			]
		);

		$this->add_control(
			'border',
			[
				'label' => __( 'Show Border', 'beautypress' ),
				'type' => Controls_Manager::SWITCHER,
				'default'       => 'yes',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
			]
		);

		$this->add_control(
			'border_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-beauty-product' => 'border-color: {{VALUE}};',
				],
				'condition'	=>	[
					'border'	=> 'yes',
				],
			]
		);

		$this->end_controls_section();

		/**
		 *
		 *Icon Style
		 *
		*/

        $this->start_controls_section(
			'section_icon_tab',
			[
				'label' => __( 'Icon', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'	=>	[
					'style'	=>	['style1','style2']
				],
			]
		);

		$this->add_control(
			'is_icon',
			[
				'label' => __( 'Show Icon', 'beautypress' ),
				'type' => Controls_Manager::SWITCHER,
				'default'       => 'yes',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
			]
		);

		$this->add_control(
			'icon_opacity',
			[
				'label' => __( 'Opacity', 'beautypress' ),
				'type' => Controls_Manager::NUMBER,
				'step'    => .1,
                'condition'	=>	[
					'is_icon'	=> 'yes',
				],
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-beauty-product .beautypress-beauty-product-footer i ' => 'opacity: {{VALUE}};',
					'{{WRAPPER}} .beautypress-single-our-feature i' => 'opacity: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-beauty-product .beautypress-beauty-product-footer i ' => 'color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-single-our-feature i ' => 'color: {{VALUE}};',
				],
				'condition'	=>	[
					'is_icon'	=> 'yes',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icon_typography',
				'label' => __( 'Typography', 'beautypress' ),
				'selector' => '{{WRAPPER}} .beautypress-single-beauty-product .beautypress-beauty-product-footer i, .beautypress-single-our-feature i',
				'condition'	=>	[
					'is_icon'	=> 'yes',
				],
			]
		);

		$this->end_controls_section();

		/**
		 *
		 *Button Style
		 *
		*/

        $this->start_controls_section(
			'section_btn_tab',
			[
				'label' => __( 'Button', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'	=>	[
					'style'	=> ['style1','style2','style3'],
				],
			]
		);

        /**
		 *
		 * Start Normal Tab Style
		 *
		*/

		$this->start_controls_tabs( 'tabs_btn_style' );

		$this->start_controls_tab(
			'tab_btn_normal',
			[
				'label' => __( 'Normal', 'beautypress' ),
			]
		);

		$this->add_control(
			'btn_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-our-feature .beautypress-our-features-content .beautypress-btn-wraper a ' => 'color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-single-beauty-product .icon-btn-with-text:before ' => 'color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-btn' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_control(
			'btn_bg_color',
			[
				'label' => __( 'BG Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-our-feature .beautypress-our-features-content .beautypress-btn-wraper a ' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-single-beauty-product .icon-btn-with-text:before' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-btn' => 'background-color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'label' => __( 'Typography', 'beautypress' ),
				'selector' => '{{WRAPPER}} .beautypress-single-our-feature .beautypress-our-features-content .beautypress-btn-wraper a, .beautypress-single-beauty-product .icon-btn-with-text:before,
					.beautypress-btn'
			]
		);

		$this->end_controls_tab();

		/**
		 *
		 * Start Hover Tab Style
		 *
		*/

		$this->start_controls_tab(
			'tab_btn_hover',
			[
				'label' => __( 'Hover', 'beautypress' ),
			]
		);

		$this->add_control(
			'btn_hover_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-our-feature .beautypress-our-features-content .beautypress-btn-wraper a.beautypress-btn:hover' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .beautypress-single-beauty-product .icon-btn-with-text:hover:after' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .beautypress-btn:hover' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_control(
			'btn_hover_bg_color',
			[
				'label' => __( 'BG Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-our-feature .beautypress-our-features-content .beautypress-btn-wraper a.beautypress-btn:hover ' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-single-beauty-product .icon-btn-with-text:hover:before ' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .beautypress-btn.bg-color-purple.purple-2 span' => 'background-color: {{VALUE}}!important;',
					'{{WRAPPER}} .beautypress-btn.bg-color-purple span' => 'background-color: {{VALUE}}!important;',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
        
    }

    protected function render( ) {
    	
        $settings = $this->get_settings();

        $style = $settings['style'];

        $image = $settings['image'];

        $icon = $settings['icon'];

        $is_icon = $settings['is_icon'];

        $title = $settings['title'];

        $sub_title = $settings['sub_title'];

        $border = ( !$settings['border'] ) ? 'xs-noborder' : '';

        $btn_label = $settings['btn_label'];

        $btn_link = (! empty( $settings['btn_link']['url'])) ? $settings['btn_link']['url'] : '';
		
		$btn_target = ( $settings['btn_link']['is_external']) ? '_blank' : '_self';

		switch ($style) {

			case 'style1':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/image-box/style1.php');
				break;

			case 'style2':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/image-box/style2.php');
				break;

			case 'style3':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/image-box/style3.php');
				break;

			case 'style4':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/image-box/style4.php');
				break;

		}
    }



    protected function content_template() { }
}