<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class XS_Image_Box_Widget_02 extends Widget_Base {

    public function get_name() {
        return 'xs-image-box-02';
    }

    public function get_title() {
        return __( 'Beautypress Image Box 02', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-image-box';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Image Box 02', 'beautypress'),
            ]
        );

        $this->add_control(

            'style', [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                ],
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __( 'Image', 'beautypress' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'label_block' => true,
            ]
        );

        $this->add_group_control(
			\Xs_Group_Control_Image_Size::get_type(),
			[
				'name' => 'image',
				'label' => __( 'Image Size', 'beautypress' ),
				'default' => 'full',
			]
		);

        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'beautypress' ),
				'type' => Controls_Manager::ICON,
				'label_block' => true,
				'default' => 'xsicon icon-soap',
				
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'beautypress' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __( 'Add title', 'beautypress' ),
                'default' => __( 'Add Title', 'beautypress' ),
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __( 'Sub Title', 'beautypress' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => __( 'When an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries', 'beautypress' ),
                
            ]
        );


        $this->end_controls_section();

        /**
		 *
		 *Title Style
		 *
		*/

        $this->start_controls_section(
			'section_title_tab',
			[
				'label' => __( 'Title', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content h2' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label' => __( 'Hover Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content:hover h2' => 'color: {{VALUE}};',
				],
				
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'beautypress' ),
				'selector' => '{{WRAPPER}} .beautypress-single-square-service-content h2',
			]
		);

		$this->end_controls_section();


		/**
		 *
		 *Sub Title Style
		 *
		*/

        $this->start_controls_section(
			'section_sub_title_tab',
			[
				'label' => __( 'Sub Title', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'sub_title_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content p ' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'sub_hover_title_color',
			[
				'label' => __( 'Hover Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content:hover p ' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_title_typography',
				'label' => __( 'Typography', 'beautypress' ),
				'selector' => '{{WRAPPER}} .beautypress-single-square-service-content p',
			]
		);

		$this->end_controls_section();


		/**
		 *
		 *Icon Style
		 *
		*/

        $this->start_controls_section(
			'section_icon_tab',
			[
				'label' => __( 'Icon', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'icon_opacity',
			[
				'label' => __( 'Opacity', 'beautypress' ),
				'type' => Controls_Manager::NUMBER,
				'step'    => .1,
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content i ' => 'opacity: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content i ' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_hover_color',
			[
				'label' => __( 'Hover Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content:hover i ' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icon_typography',
				'label' => __( 'Typography', 'beautypress' ),
				'selector' => '{{WRAPPER}} .beautypress-single-square-service-content i',
			]
		);

		$this->end_controls_section();

		/**
		 *
		 * Background Section
		 *
		 */

		$this->start_controls_section(
			'section_bg_tab',
			[
				'label' => __( 'Background', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'bg_color',
			[
				'label' => __( 'Background Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content:before ' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'bg_hover_color',
			[
				'label' => __( 'Background Hover Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content:hover:before, {{WRAPPER}} .beautypress-overlay-with-img' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_border_tab',
			[
				'label' => __( 'Border', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'border_width',
			[
				'label' => __( 'Border Width', 'beautypress' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 0,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content:before' => 'border-width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'border_color',
			[
				'label' => __( 'Border Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default'	=> '#6f42c1',
				'selectors' => [
					'{{WRAPPER}} .beautypress-single-square-service-content:before' => 'border-color: {{VALUE}};border-style:solid;',
				],
			]
		);

		$this->end_controls_section();
		
        
    }

    protected function render( ) {
    	
        $settings = $this->get_settings();

        $style = $settings['style'];

        $icon = $settings['icon'];

        $title = $settings['title'];

        $sub_title = $settings['sub_title'];

		switch ($style) {

			case 'style1':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/image-box-02/style1.php');
				break;

			case 'style2':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/image-box-02/style2.php');
				break;
		}
    }



    protected function content_template() { }
}