<?php

namespace Elementor;

if ( !defined( 'ABSPATH' ) )
	exit;

class Xs_Heading_Widget extends Widget_Base {

	public function get_name() {
		return 'xs-heading';
	}

	public function get_title() {
		return __( 'Beautypress Heading', 'beautypress' );
	}

	public function get_icon() {
		return 'eicon-heading';
	}

	public function get_categories() {
		return [ 'beautypress-elements' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
		'section_tab', [
			'label' => __( 'Beautypress Heading', 'beautypress' ),
		]
		);

		$this->add_control(
		'style', [
			'type'		 => Controls_Manager::SELECT,
			'label'		 => __( 'Choose Style', 'beautypress' ),
			'default'	 => 'style1',
			'label_block'	 => true,
			'options'	 => [
				'style1' => __( 'Watermark Title', 'beautypress' ),
				'style3' => __( 'Title with bg icon', 'beautypress' ),
				'style4' => __( 'Watermark title with top icon', 'beautypress' ),
				'style5' => __( 'Number watermark title', 'beautypress' ),
				'style2' => __( 'Styllish title', 'beautypress' ),
			],
		]
		);

		$this->add_control(
		'title_text', [
			'label'			 => __( 'Heading Title', 'beautypress' ),
			'type'			 => Controls_Manager::TEXT,
			'label_block'	 => true,
			'placeholder'	 => __( 'Add title', 'beautypress' ),
			'default'		 => __( 'Add Title', 'beautypress' ),
		]
		);

		$this->add_control(
		'sub_title', [
			'label'			 => __( 'Heading Sub Title', 'beautypress' ),
			'type'			 => Controls_Manager::TEXTAREA,
			'label_block'	 => true,
			'placeholder'	 => __( 'Description', 'beautypress' ),
			'default'		 => __( 'One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly.', 'beautypress' ),
		]
		);

		$this->add_control(
		'water_mark', [
			'label'		 => __( 'Show Water Title', 'beautypress' ),
			'type'		 => Controls_Manager::SWITCHER,
			'default'	 => 'yes',
			'label_on'	 => __( 'Yes', 'beautypress' ),
			'label_off'	 => __( 'No', 'beautypress' ),
			'condition'	 => [
				'style' => ['style1', 'style4', 'style5' ],
			],
		]
		);

		$this->add_control(
		'water_title', [
			'label'			 => __( 'Water Mark Title', 'beautypress' ),
			'type'			 => Controls_Manager::TEXT,
			'label_block'	 => true,
			'placeholder'	 => __( 'Add title', 'beautypress' ),
			'default'		 => __( 'Add Title', 'beautypress' ),
			'condition'		 => [
				'water_mark' => 'yes',
				'style'		 => ['style1', 'style4', 'style5' ],
			],
		]
		);

		$this->add_control(
		'is_icon', [
			'label'		 => __( 'Show Icon', 'beautypress' ),
			'type'		 => Controls_Manager::SWITCHER,
			'default'	 => 'yes',
			'label_on'	 => __( 'Yes', 'beautypress' ),
			'label_off'	 => __( 'No', 'beautypress' ),
			'condition'	 => [
				'style' => ['style3', 'style4' ],
			],
		]
		);

		$this->add_control(
		'icon', [
			'label'			 => __( 'Icon', 'beautypress' ),
			'type'			 => Controls_Manager::ICON,
			'label_block'	 => true,
			'default'		 => 'xsicon icon-soap',
			'condition'		 => [
				'style'		 => ['style3', 'style4' ],
				'is_icon'	 => 'yes',
			],
		]
		);

		$this->add_control(
		'is_image', [
			'label'		 => __( 'Show Image', 'beautypress' ),
			'type'		 => Controls_Manager::SWITCHER,
			'label_on'	 => __( 'Yes', 'beautypress' ),
			'label_off'	 => __( 'No', 'beautypress' ),
			'condition'	 => [
				'style' => ['style4' ],
			],
		]
		);

		$this->add_control(
		'image', [
			'label'			 => __( 'Image', 'beautypress' ),
			'type'			 => Controls_Manager::MEDIA,
			'default'		 => [
				'url' => Utils::get_placeholder_image_src(),
			],
			'label_block'	 => true,
			'condition'		 => [
				'style'		 => ['style4' ],
				'is_image'	 => 'yes',
			],
		]
		);

		$this->add_group_control(
		\Xs_Group_Control_Image_Size::get_type(), [
			'name'		 => 'image',
			'label'		 => __( 'Image Size', 'beautypress' ),
			'default'	 => 'thumbnail',
			'condition'	 => [
				'style'		 => ['style4' ],
				'is_image'	 => 'yes',
			],
		]
		);

		$this->add_control(
		'image_position', [
			'label'		 => __( 'Position', 'beautypress' ),
			'type'		 => Controls_Manager::SELECT,
			'default'	 => 'bottom',
			'options'	 => [
				'top'	 => __( 'Top', 'beautypress' ),
				'bottom' => __( 'Bottom', 'beautypress' ),
			],
			'condition'	 => [
				'style'		 => ['style4' ],
				'is_image'	 => 'yes',
			],
		]
		);

		$this->end_controls_section();

		$this->start_controls_section(
		'section_title_style', [
			'label'	 => __( 'Title', 'beautypress' ),
			'tab'	 => Controls_Manager::TAB_STYLE,
		]
		);

		/**
		 *
		 * Title Style
		 *
		 */
		$this->add_control(
		'title_color', [
			'label'		 => __( 'Title color', 'beautypress' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-sub-heading h2'									 => 'color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-big-sub-heading h2'								 => 'color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-separetor-sub-heading h2'							 => 'color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig h2'	 => 'color: {{VALUE}} !important;',
			],
		]
		);

		$this->add_control(
		'title_border', [
			'label'			 => __( 'Border', 'beautypress' ),
			'type'			 => Controls_Manager::SWITCHER,
			'default'		 => 'no',
			'return_value'	 => 'beautypress-separetor-sub-heading',
			'label_on'		 => __( 'Yes', 'beautypress' ),
			'label_off'		 => __( 'No', 'beautypress' ),
			'condition'		 => [
				'style' => ['style1', 'style2', 'style3', 'style5' ],
			],
		]
		);
		$this->add_control(
		'title_border_color', [
			'label'		 => __( 'Border color', 'beautypress' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-separetor-sub-heading:before'	 => 'background-color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-separetor-sub-heading:before'	 => 'background-image: -webkit-linear-gradient( 175deg, rgba(236,85,152,0) 0%, {{VALUE}} 24%, {{VALUE}} 46%, {{VALUE}} 100%);',
				'{{WRAPPER}} .beautypress-gradient-separetor'			 => 'background-image: -webkit-linear-gradient( 175deg, rgba(236,85,152,0) 0%, rgba(236,85,152,0.26) 24%, rgba(236,85,152,0.5) 46%, {{VALUE}} 100%);',
			],
			'condition'	 => [
				'title_border'	 => 'beautypress-separetor-sub-heading',
				'style'			 => ['style1', 'style2', 'style3', 'style5' ],
			],
		]
		);


		$this->add_control(
		'margin_bottom', [
			'label'			 => __( 'Margin Bottom', 'beautypress' ),
			'type'			 => Controls_Manager::SLIDER,
			'default'		 => [
				'size' => 1,
			],
			'range'			 => [
				'px' => [
					'min'	 => 0,
					'max'	 => 1000,
					'step'	 => 5,
				],
				'%'	 => [
					'min'	 => 0,
					'max'	 => 100,
				],
			],
			'description'	 => __( 'Enter margin bottom of the title', 'beautypress' ),
			'size_units'	 => [ 'px', '%' ],
			'selectors'		 => [
				'{{WRAPPER}} .beautypress-sub-heading'										 => 'margin-bottom: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .beautypress-big-sub-heading h2'								 => 'margin-bottom: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .beautypress-separetor-sub-heading'							 => 'margin-bottom: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig h2'	 => 'margin-bottom: {{SIZE}}{{UNIT}};',
			],
		]
		);


		$this->add_group_control(
		Group_Control_Typography::get_type(), [
			'name'		 => 'title_typography',
			'selector'	 =>
			'{{WRAPPER}} .beautypress-sub-heading h2, {{WRAPPER}} .beautypress-big-sub-heading h2,  {{WRAPPER}} .beautypress-separetor-sub-heading h2, {{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig h2',
		]
		);



		$this->add_responsive_control(
		'title_align', [
			'label'			 => __( 'Alignment', 'beautypress' ),
			'type'			 => Controls_Manager::CHOOSE,
			'options'		 => [
				'left'		 => [
					'title'	 => __( 'Left', 'beautypress' ),
					'icon'	 => 'fas fa-align-left',
				],
				'center'	 => [
					'title'	 => __( 'Center', 'beautypress' ),
					'icon'	 => 'fas fa-align-center',
				],
				'right'		 => [
					'title'	 => __( 'Right', 'beautypress' ),
					'icon'	 => 'fas fa-align-right',
				],
				'justify'	 => [
					'title'	 => __( 'Justified', 'beautypress' ),
					'icon'	 => 'fas fa-align-justify',
				],
			],
			'default'		 => '',
			'prefix_class'	 => 'xs-heading-text-%s',
		]
		);
		$this->end_controls_section();

		/**
		 *
		 * Subtitle section
		 *
		 */
		$this->start_controls_section(
		'section_sub_title_style', [
			'label'	 => __( 'Sub Title', 'beautypress' ),
			'tab'	 => Controls_Manager::TAB_STYLE,
		]
		);
		$this->add_control(
		'sub_title_color', [
			'label'		 => __( 'Sub Title color', 'beautypress' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-heading-text-content p'							 => 'color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-big-sub-heading h3'								 => 'color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-simple-text p'									 => 'color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig p'	 => 'color: {{VALUE}};',
			],
		]
		);

		$this->add_group_control(
		Group_Control_Typography::get_type(), [
			'name'		 => 'sub_style1_title_typography',
			'selector'	 => '{{WRAPPER}} .beautypress-heading-text-content p, {{WRAPPER}} .beautypress-big-sub-heading h3, {{WRAPPER}} .beautypress-simple-text p, {{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig p',
		]
		);

		$this->end_controls_section();

		/**
		 *
		 * Water Market Title Section
		 *
		 */
		$this->start_controls_section(
		'section_water_title_style', [
			'label'		 => __( 'Water Marker Title', 'beautypress' ),
			'tab'		 => Controls_Manager::TAB_STYLE,
			'condition'	 => [
				'style' => ['style1', 'style4', 'style5' ],
			],
		]
		);

		$this->add_responsive_control(
		'water_top', [
			'label'		 => __( 'Top', 'beautypress' ),
			'type'		 => Controls_Manager::SLIDER,
			'range'		 => [
				'px' => [
					'min'	 => -100,
					'max'	 => 100,
					'step'	 => 1,
				],
				'%'	 => [
					'min'	 => -100,
					'max'	 => 100,
				],
			],
			'size_units' => [ 'px', '%' ],
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig h2:before' => 'top: {{SIZE}}{{UNIT}};',
			],
			'condition'	 => [
				'style' => ['style4' ],
			],
		]
		);

		$this->add_responsive_control(
		'water_left', [
			'label'		 => __( 'Left', 'beautypress' ),
			'type'		 => Controls_Manager::SLIDER,
			'range'		 => [
				'min'	 => -100,
				'max'	 => 100,
			],
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig h2:before' => 'left: {{SIZE}}%;',
			],
			'condition'	 => [
				'style' => ['style4' ],
			],
		]
		);

		$this->add_control(
		'water_title_color', [
			'label'		 => __( 'Title color', 'beautypress' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-sub-heading.beautypress-watermark-title h2:before'		 => 'color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-section-headinig.beautypress-watermark-title h2:before'	 => 'color: {{VALUE}};',
			],
		]
		);

		$this->add_control(
		'water_opacity', [
			'label'		 => __( 'Opacity', 'beautypress' ),
			'type'		 => Controls_Manager::SLIDER,
			'range'		 => [
				'px' => [
					'min'	 => 0,
					'max'	 => 1,
					'step'	 => .1,
				],
			],
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-sub-heading.beautypress-watermark-title h2:before'		 => 'opacity: {{SIZE}};',
				'{{WRAPPER}} .beautypress-section-headinig.beautypress-watermark-title h2:before'	 => 'opacity: {{SIZE}};',
			],
		]
		);

		$this->add_group_control(
		Group_Control_Typography::get_type(), [
			'name'		 => 'water_typography',
			'selector'	 => '{{WRAPPER}} .beautypress-sub-heading.beautypress-watermark-title h2:before, {{WRAPPER}} .beautypress-section-headinig.beautypress-watermark-title h2:before',
		]
		);
		$this->end_controls_section();

		/**
		 *
		 * Icon Style Section
		 *
		 */
		$this->start_controls_section(
		'section_icon_style', [
			'label'		 => __( 'Icon', 'beautypress' ),
			'tab'		 => Controls_Manager::TAB_STYLE,
			'condition'	 => [
				'style' => ['style3', 'style4' ],
			],
		]
		);
		$this->add_control(
		'icon_color', [
			'label'		 => __( 'Title color', 'beautypress' ),
			'type'		 => Controls_Manager::COLOR,
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-watermark-icon i'									 => 'color: {{VALUE}};',
				'{{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig i'	 => 'color: {{VALUE}};',
			],
		]
		);

		$this->add_control(
		'icon_opacity', [
			'label'		 => __( 'Opacity', 'beautypress' ),
			'type'		 => Controls_Manager::SLIDER,
			'range'		 => [
				'px' => [
					'min'	 => 0,
					'max'	 => 1,
					'step'	 => .1,
				],
			],
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-watermark-icon i'									 => 'opacity: {{SIZE}};',
				'{{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig i'	 => 'opacity: {{SIZE}};',
			],
		]
		);

		$this->add_control(
		'icon_size', [
			'label'		 => __( 'Size', 'beautypress' ),
			'type'		 => Controls_Manager::SLIDER,
			'range'		 => [
				'px' => [
					'min'	 => 0,
					'max'	 => 1000,
					'step'	 => 1,
				],
			],
			'size_units' => [ 'px' ],
			'selectors'	 => [
				'{{WRAPPER}} .beautypress-watermark-icon i'									 => 'font-size: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .beautypress-watermark-title.beautypress-section-headinig i'	 => 'font-size: {{SIZE}}{{UNIT}};',
			],
		]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

		$style = $settings[ 'style' ];

		$title = $settings[ 'title_text' ];

		$title_border = ($settings[ 'title_border' ] != 'no' ? $settings[ 'title_border' ] : '');

		$sub_title = $settings[ 'sub_title' ];

		$water_mark = ($settings[ 'water_mark' ]);

		if ( $water_mark ) {
			$water_title = ($settings[ 'water_title' ]) ? $settings[ 'water_title' ] : '';
		} else {
			$water_title = '';
		}

		$is_icon = $settings[ 'is_icon' ];

		$icon = ($settings[ 'icon' ] != '') ? $settings[ 'icon' ] : '';

		$is_image = $settings[ 'is_image' ];

		$image_position = $settings[ 'image_position' ];

		switch ( $style ) {

			case 'style1':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE . '/heading/style1.php');
				break;

			case 'style2':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE . '/heading/style2.php');
				break;

			case 'style3':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE . '/heading/style3.php');
				break;

			case 'style4':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE . '/heading/style4.php');
				break;

			case 'style5':
				include(BEAUTYPRESS_SHORTCODE_DIR_STYLE . '/heading/style5.php');
				break;
		}
	}

	protected function content_template() {
		
	}

}
