<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Fun_Fact_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-fun-fact';
    }

    public function get_title() {
        return __( 'Beautypress Fun Fact', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-counter';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Fun fact', 'beautypress'),
            ]
        );

        $this->add_control(

            'style', 
            [
                'type' => Controls_Manager::SELECT,
                'label' => __('Choose Style', 'beautypress'),
                'default' => 'style1',
                'options' => [
                    'style1' => __('Style 1', 'beautypress'),
                    'style2' => __('Style 2', 'beautypress'),
                ],
            ]
        );

        /**
         *
         * Fun Fact Content Feild
         *
         */

        $this->add_control(

            'fact_name', 
            [

                'label' => __('Label', 'beautypress'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default'   => __('Specialist', 'beautypress'),
                // 'condition' =>  [
                //     'style' =>  'style1'
                // ],
            ]
        );

        $this->add_control(

            'fact_value', 
            [
                
                'label' => __('Value', 'beautypress'),
                'type' => Controls_Manager::NUMBER,
                'default'    => __('4000', 'beautypress'), 
                'label_block' => true,
                // 'condition' =>  [
                //     'style' =>  'style1'
                // ],
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __( 'Icon', 'beautypress' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
                'default' => 'xsicon icon-soap',
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Label Custom Style
         *
         */
        

        $this->start_controls_section(
            'section_label_style',
            [
                'label' => __('Label', 'beautypress'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'label_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-fun-factory h5 ' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'label_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-single-fun-factory h5'
            ]
        );

        $this->end_controls_section();

        /**
         *
         * value Custom Style
         *
         */
        

        $this->start_controls_section(
            'section_value_style',
            [
                'label' => __('Value', 'beautypress'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'value_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-counter h2' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'value_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-counter h2',
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Icon Custom Style
         *
         */
        

        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => __('Icon', 'beautypress'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-fun-factory i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-single-fun-factory i' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'icon_opacity',
            [
                'label' => __( 'Opacity', 'beautypress' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .beautypress-single-fun-factory i' => 'opacity: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'icon_typography',
                'label' => __( 'Typography', 'beautypress' ),
                'selector' => '{{WRAPPER}} .beautypress-single-fun-factory i',
            ]
        );

        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        $style = $settings['style'];

        $fact_name = $settings['fact_name'];

        $fact_value = $settings['fact_value'];

        $icon = $settings['icon'];

        switch ($style) {
            case 'style1':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/fun-fact/style1.php');
                break;
            
            case 'style2':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/fun-fact/style2.php');
                break;
        }
        ?>
    <?php  
    }

    protected function content_template() { }
}