<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class XS_Faq_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-faq';
    }

    public function get_title() {
        return __( 'Beautypress Faq', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-accordion';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Accordion', 'beautypress'),
            ]
        );

        $this->add_control(
            'style',
            [
                'label'     => esc_html__( 'Style', 'beautypress' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'style1',
                'options'   => [
                        'style1'     => esc_html__( 'Style 1', 'beautypress' ),
                        'style2'     => esc_html__( 'Style 2', 'beautypress' ),
                ],
            ]
        );

		$repeater = new Repeater();

		$repeater->add_control(
			'tab_content', [
				'label' => __( 'Content', 'beautypress' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => __( 'Accordion Content', 'beautypress' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Title', 'beautypress' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Accordion Title' , 'beautypress' ),
				'label_block' => true,
			]
		);

		$this->add_control(
			'xs_faq',
			[
				'label' => __( 'Accordion Items', 'beautypress' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title' => __( 'Accordion #1', 'beautypress' ),
						'tab_content' => __( 'I am item content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'beautypress' ),
					],
					[
						'tab_title' => __( 'Accordion #2', 'beautypress' ),
						'tab_content' => __( 'I am item content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'beautypress' ),
					],
				],
				'title_field' => '{{{ tab_title }}}',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'section_title_style',
			[
				'label' => __( 'Accordion', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'border_width',
			[
				'label' => __( 'Border Width', 'beautypress' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 1,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion .panel.active:before' => 'border-width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'border_color',
			[
				'label' => __( 'Border Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion .panel.active:before' => 'border-color: {{VALUE}} !important;'
				],
			]
		);

		$this->add_control(
			'icon_background_color',
			[
				'label' => __( 'Icon Background Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion.beautypress-version-2 .panel-heading a:before' => 'background-color: {{VALUE}} !important;',
				],
				'condition' =>  [
                	'style' => ['style2']
            	],
			]
		);

		$this->add_control(
			'icon_active_background_color',
			[
				'label' => __( 'Icon Active Background Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion.beautypress-version-2 .panel-heading a[aria-expanded="true"]:before' => 'background-color: {{VALUE}} !important;',
				],
				'condition' =>  [
                	'style' => ['style2']
            	],
			]
		);

		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'beautypress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_background',
			[
				'label' => __( 'Background', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion .panel-heading a' => 'background-color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'title_active_background',
			[
				'label' => __( 'Active Background Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion .panel-heading a[aria-expanded="true"]' => 'background-color: {{VALUE}} !important;;',
				],
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion .panel-heading a' => 'color: {{VALUE}} !important;;',
					'{{WRAPPER}} .beautypress-accordion .panel-heading a:before' => 'color: {{VALUE}} !important;;',
				],
			]
		);

		$this->add_control(
			'tab_active_color',
			[
				'label' => __( 'Active Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion .panel-heading a[aria-expanded="true"]' => 'color: {{VALUE}} !important;;',
					'{{WRAPPER}} .beautypress-accordion .panel-heading a[aria-expanded="true"]:before' => 'color: {{VALUE}} !important;;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .beautypress-accordion .panel-heading a',
			]
		);

		$this->add_control(
			'heading_content',
			[
				'label' => __( 'Content', 'beautypress' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'content_background_color',
			[
				'label' => __( 'Background', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion .panel-body' => 'background-color: {{VALUE}} !important;',
				],
				'condition' =>  [
                    	'style' => ['style1']
                ],
			]
		);


		$this->add_control(
			'content_color',
			[
				'label' => __( 'Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .beautypress-accordion .panel-body' => 'color: {{VALUE}} !important;;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .beautypress-accordion .panel-body',
			]
		);

		$this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();

        $style = $settings['style'];

        $xs_faq = $settings['xs_faq'];

        $parent_id = uniqid('xs-faq-parent-').mt_rand(1000,9999);

        switch ($style) {
            case 'style1':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/accordion/style1.php');
                break;

            case 'style2':
                include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/accordion/style2.php');
                break;
        }
    }

    protected function content_template() { }
}
?>