<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Contact_Info_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-contact-info';
    }

    public function get_title() {
        return __( 'Beautypress Contact Info', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-user-circle-o';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Contact Info', 'beautypress'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'beautypress' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => __( 'Our Story', 'beautypress' ),
                'default' => __( 'Our Story', 'beautypress' ),
            ]
        );

         $this->add_control(
            'style',
            [
                'label'     => esc_html__( 'Style', 'beautypress' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'style1',
                'options'   => [
                        'style1'     => esc_html__( 'Style 1', 'beautypress' ),
                        'style2'     => esc_html__( 'Style 2', 'beautypress' ),
                ],
            ]
        );

        $repeater = new Repeater();

		$repeater->add_control(
			'contact_icon', [
                'label' => __( 'Icon', 'beautypress' ),
                'type' => Controls_Manager::ICON,
                'default' =>__('fas fa-map-marker-alt','beautypress'),
                'label_block' => true,
			]
		);

		$repeater->add_control(
			'contact_value_style1', [
                'label' => __( 'Value', 'beautypress' ),
                'type' => Controls_Manager::TEXTAREA,
                'default'	=>__('121 King Street, Melbourne Victoria 3000 Australia','beautypress'),
                'label_block' => true,
			]
		);

		$this->add_control(
			'contact_info_style1',
			[
				'label' => __( 'Contact info', 'beautypress' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'contact_icon' => __( 'fas fa-map-marker-alt', 'beautypress' ),
						'contact_value_style1' => __( '121 King Street, Melbourne Victoria 3000 Australia', 'beautypress' ),
					],

					[
						'contact_icon' => __( 'fas fa-phone-alt', 'beautypress' ),
						'contact_value_style1' => __( '+91 00 00 00 00', 'beautypress' ),
					],

					[
						'contact_icon' => __( 'far fa-envelope', 'beautypress' ),
						'contact_value_style1' => __( 'mail@domain.com', 'beautypress' ),
					],

					[
						'contact_icon' => __( 'fab fa-facebook-f', 'beautypress' ),
						'contact_value_style1' => __( 'facebok.com/name', 'beautypress' ),
					],
				],
				'title_field' => '{{{ contact_icon }}}',
				'condition'	=>	[
					'style'	=>	'style1'
				],
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'contact_value', [
                'label' => __( 'Content', 'beautypress' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
			]
		);

		$repeater->add_control(
			'contact_label', [
                'label' => __( 'Label', 'beautypress' ),
                'type' => Controls_Manager::TEXT,
                'default' =>'Address',
                'label_block' => true,
			]
		);

		$this->add_control(
			'contact_info_style2',
			[
				'label' => __( 'Contact info', 'beautypress' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'contact_label' => __( 'Address', 'beautypress' ),
						'contact_value' => __( '121 King Street, Melbourne Victoria 3000 Australia', 'beautypress' ),
					],

					[
						'contact_label' => __( 'Email', 'beautypress' ),
						'contact_value' => __( '+91 00 00 00 00', 'beautypress' ),
					],

					[
						'contact_label' => __( 'Phone', 'beautypress' ),
						'contact_value' => __( 'mail@domain.com', 'beautypress' ),
					],

					[
						'contact_label' => __( 'Facebook', 'beautypress' ),
						'contact_value' => __( 'facebok.com/name', 'beautypress' ),
					],
				],
				'title_field' => '{{{ contact_label }}}',
				'condition'	=>	[
					'style'	=>	'style2'
				],
			]
		);

        $this->end_controls_section();

        /**
         *
         * general Sytle
         *
         */


        $this->start_controls_section(
            'section_general_styling',
            [
                'label' => __('General', 'beautypress'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'general_bg_color',
            [
                'label' => __( 'Background Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-contact-details' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'general_show_border',
            [
                'label'         => __( 'Show Border', 'beautypress' ),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'yes',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
            ]
        );

        $this->add_control(
            'border_width',
            [
                'label' => __('Border Width', 'beautypress'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .beautypress-contact-details' => 'border: {{SIZE}}{{UNIT}};',
                ],
                'condition'	=>	[
                	'general_show_border'	=>	'yes'
                ],
            ]
        );

        $this->add_control(
            'general_border_color',
            [
                'label' => __( 'Brder Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-contact-details' => 'border-color: {{VALUE}};',
                ],
                'condition'	=>	[
                	'general_show_border'	=>	'yes'
                ],
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Title Sytle
         *
         */


        $this->start_controls_section(
            'section_title_styling',
            [
                'label' => __('Title', 'beautypress'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-separetor-sub-heading.beautypress-version-2 h2' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-separetor-sub-heading.beautypress-version-3 h2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'show_border',
            [
                'label'         => __( 'Show Border', 'beautypress' ),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'yes',
                'label_on'      => __( 'Yes', 'beautypress' ),
                'label_off'     => __( 'No', 'beautypress' ),
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => __( 'Brder Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-separetor-sub-heading.beautypress-version-2:before' => 'background-color: {{VALUE}};',
                ],
                'condition'	=>	[
                	'show_border'	=>	'yes'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .beautypress-separetor-sub-heading.beautypress-version-2 h2',
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Icon Style
         *
         */

        $this->start_controls_section(
            'section_icon_styling',
            [
                'label' => __('Icon', 'beautypress'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'	=>	[
                	'style'	=>	'style1',
                ],
            ]
        );

        $this->add_control(
            'icon_clolor',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-icon-with-text li i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_color',
            [
                'label' => __( 'Background Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-icon-with-text li i' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_border_color',
            [
                'label' => __( 'Border Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-icon-with-text li i' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         *
         * Title Sytle
         *
         */

        $this->start_controls_section(
            'section_label_styling',
            [
                'label' => __('Label', 'beautypress'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition'	=>	[
                	'style'	=>	'style2',
                ],
            ]
        );

        $this->add_control(
            'label_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-contact-text b' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'label_typography',
                'selector' => '{{WRAPPER}} .beautypress-contact-text b',
            ]
        );

        $this->end_controls_section();

        /**
         *
         * value Sytle
         *
         */


        $this->start_controls_section(
            'section_value_styling',
            [
                'label' => __('value', 'beautypress'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'value_color',
            [
                'label' => __( 'Color', 'beautypress' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .beautypress-icon-with-text li' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .beautypress-contact-text p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'value_typography',
                'selector' => '{{WRAPPER}} .beautypress-icon-with-text li',
            ]
        );

        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        $style = $settings['style'];

        $general_show_border = $settings['general_show_border'];

        $title = $settings['title'];

        $border = ($settings['show_border']) ? '' : 'xs-noborder';

        $contact_info_style1 = $settings['contact_info_style1'];

        $contact_info_style2 = $settings['contact_info_style2'];

        switch ($style) {
        	case 'style1':
        		include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/contact-info/style1.php');
        		break;

        	case 'style2':
        		include(BEAUTYPRESS_SHORTCODE_DIR_STYLE.'/contact-info/style2.php');
        		break;
        }
    }



    protected function content_template() { }
}
?>