<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Button_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-button';
    }

    public function get_title() {
        return __( 'BeautyPress Button', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-button';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('BeautyPress Button', 'beautypress'),
            ]
        );

        $this->add_control(
			'btn_text',
			[
				'label' => __( 'Label', 'beautypress' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Learn more ', 'beautypress' ),
				'placeholder' => __( 'Learn more ', 'beautypress' ),
			]
		);

		$this->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'beautypress' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __('http://your-link.com','beautypress' ),
				'default' => [
					'url' => '#',
				],
			]
		);

		$this->add_responsive_control(
			'btn_align',
			[
				'label' => __( 'Alignment', 'beautypress' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => __( 'Left', 'beautypress' ),
						'icon' => 'fas fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'beautypress' ),
						'icon' => 'fas fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'beautypress' ),
						'icon' => 'fas fa-align-right',
					],
				],
				'prefix_class' => 'text-%s',
				'default' => '',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Button Style', 'beautypress' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'btn_border_radius',
			[
				'label' => __( 'Border Radius', 'beautypress' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px'],
				'default' => [
					'top' => 25,
					'right' => 25,
					'bottom' =>25 ,
					'left' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .beautypress-btn' =>  'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
				'label' => __( 'Typography', 'beautypress' ),
				'selector' => '{{WRAPPER}} a.beautypress-btn',
			]
		);

		$this->start_controls_tabs( 'xs_tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'beautypress' ),
			]
		);

		$this->add_control(
			'btn_text_color',
			[
				'label' => __( 'Text Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} a.beautypress-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'btn_bg_color',
			[
				'label' => __( 'Background Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.beautypress-btn' => 'background-color: {{VALUE}} !important;',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tn_tab_button_hover',
			[
				'label' => __( 'Hover', 'beautypress' ),
			]
		);

		$this->add_control(
			'btn_hover_color',
			[
				'label' => __( 'Text Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.beautypress-btn:hover' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_control(
			'btn_bg_hover_color',
			[
				'label' => __( 'Background Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.beautypress-btn.bg-color-purple span' => 'background-color: {{VALUE}} !important;',
				],
			]
		);

		$this->add_control(
			'btn_hover_border_color',
			[
				'label' => __( 'Border Color', 'beautypress' ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'border_border!' => '',
				],
				'selectors' => [
					'{{WRAPPER}} a.beautypress-btn:hover' => 'border-color: {{VALUE}};',
				],
			]
		);


        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();

        $btn_text = $settings['btn_text'];

		$btn_link = (! empty( $settings['btn_link']['url'])) ? $settings['btn_link']['url'] : '';
		
		$btn_target = ( $settings['btn_link']['is_external']) ? '_blank' : '_self';
        
        ?>
		<a href="<?php echo esc_url( $btn_link ); ?>" target="<?php echo esc_html( $btn_target ); ?>" class="beautypress-btn xs-btn bg-color-purple round-btn box-shadow-btn"><?php echo esc_html( $btn_text ); ?><span></span></a>
        <?php
    }



    protected function content_template() { }
}