<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class XS_Faq_Widget extends Widget_Base {

    public function get_name() {
        return 'xs-faq';
    }

    public function get_title() {
        return __( 'Beautypress Faq', 'beautypress' );
    }

    public function get_icon() {
        return 'eicon-accordion';
    }

    public function get_categories() {
        return [ 'beautypress-elements' ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'section_tab',
            [
                'label' => __('Beautypress Accordion', 'beautypress'),
            ]
        );


		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'tab_title', [
				'label' => __( 'Title & Content', 'beautypress' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Accordion Title' , 'beautypress' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'tab_content', [
				'label' => __( 'Content', 'beautypress' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => __( 'Accordion Content', 'beautypress' ),
				'show_label' => false,
			]
		);

		$this->add_control(
			'xs_faq',
			[
				'label' => __( 'Accordion Items', 'beautypress' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'tab_title' => __( 'Accordion #1', 'beautypress' ),
						'tab_content' => __( 'I am item content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'beautypress' ),
					],
					[
						'tab_title' => __( 'Accordion #2', 'beautypress' ),
						'tab_content' => __( 'I am item content. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'beautypress' ),
					],
				],
				'title_field' => '{{{ tab_title }}}',
			]
		);

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();
        ?>
	        <div class="beautypress-accordion beautypress-version-1">
				<div class="beautypress-simple-title mb-30">
					<h3>Frequently asked question</h3>
				</div>
				<div class="panel-group" id="accordion">
					<div class="panel panel-default active">
						<div class="panel-heading">
							<a data-toggle="collapse" data-parent="#accordion" aria-expanded="true" href="#collapse1">
								How can i help you?
							</a>
						</div>
						<div id="collapse1" class="panel-collapse collapse in">
							<div class="panel-body">
								One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections. The bedding was hardly able to cover it and seemed ready to slide off any moment.
							</div>
						</div>
					</div>
					<div class="panel panel-default">
						<div class="panel-heading">
							<a data-toggle="collapse" data-parent="#accordion" href="#collapse2">
								How to get started?
							</a>
						</div>
						<div id="collapse2" class="panel-collapse collapse">
							<div class="panel-body">
								One morning, when Gregor Samsa woke from troubled dreams, he found himself transformed in his bed into a horrible vermin. He lay on his armour-like back, and if he lifted his head a little he could see his brown belly, slightly domed and divided by arches into stiff sections. The bedding was hardly able to cover it and seemed ready to slide off any moment.
							</div>
						</div>
					</div>
				</div>
			</div>
        <?php
    }



    protected function content_template() { }
}
?>