<?php if(is_array($team_members) && !empty($team_members)): ?>
<div class="beautypress-team-slider owl-carousel">
	<?php foreach($team_members as $members): ?>
		<div class="beautypress-single-team-slider">
			<?php if(!empty($members['member_image'])):?>
				<div class="beautypress-team-member-img">
					<?php 
			    		$image = \xs_resize( (empty($members['member_image']['id'])) ? $members['member_image']['url'] : $members['member_image']['id'], 516, 790,true );
					?>
					<img src="<?php echo esc_url($image); ?>" alt="<?php echo esc_html( $members['member_name'] ); ?>">
				</div>
			<?php endif; ?>
			<div class="beautypress-team-content-v4">
				<?php if($members['member_show_social']): ?>
					<ul class="beautypress-social-list">
						<?php if($members['facebook_url'] != '' ): ?>
	                        <li><a href="<?php echo esc_url($members['facebook_url']) ?>" class="beautypress-facebook"><i class="fab fa-facebook"></i></a></li>
	                    <?php endif; ?>

	                    <?php if($members['twitter_url'] != '' ): ?>
	                        <li><a href="<?php echo esc_url($members['twitter_url']) ?>" class="beautypress-twitter"><i class="fab fa-twitter"></i></a></li>
	                    <?php endif; ?>

	                    <?php if($members['linkedin_url'] != '' ): ?>
	                        <li><a href="<?php echo esc_url($members['linkedin_url']) ?>" class="beautypress-facebook"><i class="fab fa-linkedin"></i></a></li>
	                    <?php endif; ?>

	                    <?php if($members['pinterest_url'] != '' ): ?>
	                        <li><a href="<?php echo esc_url($members['pinterest_url']) ?>" class="beautypress-pinterest"><i class="fab fa-pinterest-p"></i></a></li>
	                    <?php endif; ?>

	                    <?php if($members['dribbble_url'] != ''): ?>
	                        <li><a href="<?php echo esc_url($members['dribbble_url']) ?>" class="beautypress-dribbble"><i class="fab fa-dribbble"></i></a></li>
	                    <?php endif; ?>

	                    <?php if($members['google_plus_url'] != '' ): ?>
	                        <li><a href="<?php echo esc_url($members['google_plus_url']) ?>" class="beautypress-facebook"><i class="fab fa-google-plus"></i></a></li>
	                    <?php endif; ?>

	                    <?php if($members['instagram_url'] != '' ): ?>
	                        <li><a href="<?php echo esc_url($members['instagram_url']) ?>" class="beautypress-facebook"><i class="fab fa-instagram"></i></a></li>
	                    <?php endif; ?>
					</ul>
				<?php endif; ?>
				<div class="beautypress-team-person">
					<h3><?php echo esc_html( $members['member_name'] ); ?></h3>
					<h4><?php echo esc_html( $members['member_position'] ); ?></h4>
				</div>
				<p><?php echo esc_html( $members['member_details'] ); ?></p>
				<?php if(!empty($members['btn_label'])): ?>
					<?php $btn_target = ( $members['btn_link']['is_external']) ? '_blank' : '_self'; ?>
					<?php $btn_link = (! empty( $members['btn_link']['url'])) ? $members['btn_link']['url'] : ''; ?>
					<a href="<?php echo esc_url( $btn_link); ?>" target="<?php echo esc_html( $btn_target ); ?>" class="beautypress-btn small-round-btn"><?php echo esc_html( $members['btn_label'] ); ?>
					<span></span>
					</a>
				<?php endif; ?>
			</div>
		</div>
	<?php endforeach; ?>
</div>
<?php endif; ?>