<?php if(is_array($sliders) && !empty($sliders)): ?>
    <div class="beautypress-welcome-slider-wraper">
        <div class="beautypress-welcome-slider owl-carousel welcome-height-calc-minus" <?php echo sprintf( 'data-settings=\'%1$s\'', $slider_settings ); ?>>
            <?php foreach($sliders as $slider): ?>
                <?php
                    $btn_link_one = (! empty( $slider['btn_link_one']['url'])) ? $slider['btn_link_one']['url'] : '';

                    $btn_target_one = ( $slider['btn_link_one']['is_external']) ? '_blank' : '_self';

                    $btn_link_two = (! empty( $slider['btn_link_two']['url'])) ? $slider['btn_link_two']['url'] : '';

                    $btn_target_two = ( $slider['btn_link_one']['is_external']) ? '_blank' : '_self';

                    $image = \xs_resize($slider['image']['url']);

                    $alignment = $slider['alignment'];
                ?>
                <div class="beautypress-welcome-slider-item content-<?php echo esc_attr($alignment); ?> beautypress-bg" style="background-image: url(<?php echo esc_url($image); ?>);">
                    <div class="container">
                        <div class="beautypress-welcome-content-group">
                            <div class="beautypress-welcome-avatar"></div>
                            <div class="beautypress-welcome-container">
                                <div class="beautypress-welcome-wraper">

                                    <?php if(!empty($slider['title'])): ?>
                                        <h2 class="color-pink"><?php echo esc_html( $slider['title'] ); ?></h2>
                                    <?php endif;?>

                                    <?php if(!empty($slider['sub_title'])): ?>
                                        <h3 class="color-purple"><?php echo esc_html( $slider['sub_title'] ); ?></h3>
                                    <?php endif;?>

                                    <?php if(!empty($slider['description'])): ?>
                                    <p class="color-black"><?php echo wp_kses_post( $slider['description'] ); ?></p>
                                    <?php endif;?>

                                    <div class="beautypress-btn-wraper">

                                        <?php if(!empty($slider['btn_label_one'])): ?>
                                            <a href="<?php echo esc_url( $btn_link_one ); ?>" target="<?php echo esc_html( $btn_target_one ); ?>" class="beautypress-btn xs-btn bg-color-pink round-btn box-shadow-btn"><?php echo esc_html( $slider['btn_label_one'] ); ?><span></span></a>
                                        <?php endif;?>

                                        <?php if(!empty($slider['btn_label_two'])): ?>
                                            <a href="<?php echo esc_url( $btn_link_two ); ?>" target="<?php echo esc_html( $btn_target_two ); ?>" class="beautypress-btn xs-btn bg-color-purple round-btn box-shadow-btn"><?php echo esc_html( $slider['btn_label_two'] ); ?> <span></span></a>
                                        <?php endif;?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="beautypress-black-gradient-overlay"></div>
                    </div>
                </div>
            <?php  endforeach; ?>
        </div>
    </div>
<?php endif; ?>