<div class="beautypress-single-pricing-table beautypress-image-overlay-1 beautypress-version-3">
	<div class="beautypress-pricing-header">
		<?php if(!empty($pricing_image)): ?>
            <?php $image = \xs_resize( $pricing_image['id'], 105, 110 ); ?>
            <img src="<?php echo esc_url($pricing_image['url']); ?>" alt="<?php echo esc_html($pricing_plan_title) ?>">
        <?php endif;?>
		<div class="beautypress-pricing-header-content">
			<div class="beautypress-pricing-title">
				<h2><?php echo esc_html($pricing_plan_title) ?></h2>
			</div>
			<div class="beautypress-pricing-price">
				<?php if($pricing_plan_tag != ''): ?>
					<h4><?php echo esc_html($pricing_plan_tag) ?></h4>
				<?php endif; ?>
				<h5><span><?php echo esc_html($pricing_plan_currency) ?></span><?php echo esc_html($pricing_plan_price) ?></h5>
			</div>
		</div>
	</div><!-- .beautypress-pricing-header END -->
	<div class="beautypress-pricing-footer">
		<?php if(is_array($pricing_content) && !empty($pricing_content)): ?>
			<ul class="beautypress-both-side-list">
				<?php foreach($pricing_content as $contents): ?>
					<li><?php echo esc_html($contents['pricing_title']) ?><span><?php echo esc_html($contents['pricing_tag']) ?></span></li>
				<?php endforeach; ?>
			</ul>
		<?php endif; ?>

		<?php if($pricing_btn_text != ''): ?>
			<div class="beautypress-btn-wraper">
				<a href="<?php echo esc_url($pricing_btn_link); ?>" target="<?php echo esc_attr($target) ?>" class="beautypress-btn xs-btn round-btn box-shadow-btn bg-color-purple"><?php echo esc_html($pricing_btn_text) ?><span></span></a>
			</div>
		<?php endif;  ?>
	</div>
</div>