<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class Xs_Shortcode{

	/**
     * Holds the class object.
     *
     * @since 1.0
     *
     */
	public static $_instance;

	/**
     * Load Construct
     *
     * @since 1.0
     */

	public function __construct(){

		add_action('elementor/init', array($this, 'xs_elementor_init'));
        add_action('elementor/controls/controls_registered', array( $this, 'xs_icon_pack' ), 11 );
        add_action('elementor/controls/controls_registered', array( $this, 'add_controls' ), 11 );
        add_action('elementor/widgets/widgets_registered', array($this, 'xs_shortcode_elements'));
        add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
        add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        add_action( 'elementor/preview/enqueue_styles', array( $this, 'preview_enqueue_scripts' ) );

	}

    /**
     * Enqueue editor styles
     *
     * @return void
     */

    public function editor_enqueue_styles() {
        wp_enqueue_style( 'xs-icon-elementor', BEAUTYPRESS_CSS.'/xs-icon.css',null, BEAUTYPRESS_VERSION );
    }

    /**
     * Enqueue Scripts
     *
     * @return void
     */

     public function enqueue_scripts() {
        wp_enqueue_script( 'xs-main-elementor', BEAUTYPRESS_SCRIPTS . '/xs-admin.js',array( 'jquery', 'elementor-frontend' ), BEAUTYPRESS_VERSION, true );
    }

    /**
     * Preview Enqueue Scripts
     *
     * @return void
     */

     public function preview_enqueue_scripts() {
        wp_enqueue_style('xs-admin-elementor', BEAUTYPRESS_CSS . '/xs-admin.css', null, BEAUTYPRESS_VERSION);
    }


    /**
     * Extend Icon pack core controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
    */

    public function xs_icon_pack( $controls_manager ) {

        require_once (BEAUTYPRESS_SHORTCODE_DIR. 'controls/xs-icon.php');

        $controls = array(
            $controls_manager::ICON => 'Xs_Icon_Controler',
        );

        foreach ( $controls as $control_id => $class_name ) {
            $controls_manager->unregister_control( $control_id );
            $controls_manager->register_control( $control_id, new $class_name() );
        }

    }

    /**
     * Add new controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
     */
    public function add_controls( $controls_manager ) {
        require_once (BEAUTYPRESS_SHORTCODE_DIR. 'controls/groups/xs-image-size.php');

        $grouped = array(
            'xs-image-size' => 'Xs_Group_Control_Image_Size',
        );

        foreach ( $grouped as $control_id => $class_name ) {
            $controls_manager->add_group_control( $control_id, new $class_name() );
        }

    }

	/**
     * Elementor Initialization
     *
     * @since 1.0
     *
     */

    public function xs_elementor_init(){
        \Elementor\Plugin::$instance->elements_manager->add_category(
            'beautypress-elements',
            [
                'title' => __( 'BeautyPress', 'beautypress' ),
                'icon' => 'fas fa-plug',
            ],
            1
        );
    }



    public function xs_shortcode_elements($widgets_manager){

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-service.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Service_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-posts.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Post_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-partner.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Partner_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-heading.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Heading_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-team.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Team_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-price.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Price_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-button.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Button_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-video.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Video_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-icon-list.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Icon_List_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-schedule.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Schedule_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-testimonial.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Testimonial_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-image-box.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Image_Box_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-image-box-02.php';
        $widgets_manager->register_widget_type(new Elementor\XS_Image_Box_Widget_02());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-fun-fact.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Fun_Fact_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-faq.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Faq_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-portfolio.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Portfolio_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-contact-info.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Contact_Info_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Slider_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-single-image.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Single_Image_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-image-comparison.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Image_comparison_Widget());

        require_once BEAUTYPRESS_SHORTCODE_DIR.'xs-map.php';
        $widgets_manager->register_widget_type(new Elementor\Xs_Maps_Widget());

    }

	public static function xs_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new Xs_Shortcode();
        }
        return self::$_instance;
    }

}
$Xs_Shortcode = Xs_Shortcode::xs_get_instance();

if(!defined('ELEMENTOR_PRO_VERSION')){
    add_action( 'elementor/editor/after_enqueue_styles', function() {
        wp_enqueue_style( 'xs-elementor-editor-panel',  BEAUTYPRESS_CSS . '/elementor-editor-panel.css', null,  BEAUTYPRESS_VERSION );
    });
}