<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * register required plugins
 */

function beautypress_register_required_plugins() {
	$plugins	 = array(
		array(
			'name'		 => esc_html__( 'Unyson Custom', 'beautypress' ),
			'slug'       => 'unyson',
            'required'   => true,
            'version'    => '2.8.0',
            'source'     =>  BEAUTYPRESS_GLOBAL_UNYSON . '/unyson.zip',
		),
		array(
			'name'		 => esc_html__( 'Elementor', 'beautypress' ),
			'slug'		 => 'elementor',
			'required'	 => true,
		),
        array(
            'name'		 => esc_html__( 'Elementskit Lite', 'beautypress' ),
            'slug'		 => 'elementskit-lite',
            'required'	 => true,
        ),
		array(
			'name'		 => esc_html__( 'Metform', 'beautypress' ),
			'slug'		 => 'metform',
			'required'	 => true,
		),
		array(
			'name'		 => esc_html__( 'WooCommerce', 'beautypress' ),
			'slug'		 => 'woocommerce',
			'required'	 => true,
		),
		array(
			'name'		 => esc_html__( 'Beautypress Features', 'beautypress' ),
			'slug'		 => 'beautypress-features',
			'required'	 => true,
			'version'	 => '1.4',
            'source'	 =>  esc_url(BEAUTYPRESS_REMOTE_CONTENT . '/plugins/beautypress-features.zip')
		),
        array(
            'name'		 => esc_html__( 'Slider Revolution', 'beautypress' ),
            'slug'		 => 'revslider',
			'required'	 => true,
			'version'	 => '6.5.7',
            'source'	 =>  esc_url(BEAUTYPRESS_REMOTE_CONTENT . '/plugins/revslider.zip')
        ),
        array(
            'name'		 => esc_html__( 'Booked', 'beautypress' ),
            'slug'		 => 'booked',
			'required'	 => true,
			'version'    => '2.3.6',
            'source'	 =>  esc_url(BEAUTYPRESS_REMOTE_CONTENT . '/plugins/booked.zip')
        ),
		array(
            'name'		 => esc_html__( 'GetGenie – Conversion-Friendly & SEO-Optimized Content with AI Magic', 'beautypress' ),
            'slug'		 => 'getgenie',
        ),
	);


	$config = array(
		'id'			 => 'beautypress', // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path'	 => '', // Default absolute path to bundled plugins.
		'menu'			 => 'beautypress-install-plugins', // Menu slug.
		'parent_slug'	 => 'themes.php', // Parent menu slug.
		'capability'	 => 'edit_theme_options', // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'	 => true, // Show admin notices or not.
		'dismissable'	 => true, // If false, a user cannot dismiss the nag message.
		'dismiss_msg'	 => '', // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic'	 => false, // Automatically activate plugins after installation or not.
		'message'		 => '', // Message to output right before the plugins table.
	);

	tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'beautypress_register_required_plugins' );