<?php
if ( !defined( 'ABSPATH' ) )
	die( 'Direct access forbidden.' );
/**
 * Theme’s filters and actions
 */
/*
 * Widget register
 */
if ( !function_exists( 'beautypress_widget_init' ) ) {

	function beautypress_widget_init() {
		if ( function_exists( 'register_sidebar' ) ) {
			register_sidebar(
				array(
					'name'			 => esc_html__( 'Blog Widget Area', 'beautypress' ),
					'id'			 => 'sidebar-1',
					'description'	 => esc_html__( 'Appears on posts and pages.', 'beautypress' ),
					'before_widget'	 => '<div id="%1$s" class="beautypress-single-sidebar %2$s">',
					'after_widget'	 => '</div><!-- end widget -->',
					'before_title'	 => '<div class="beautypress-sidebar-heading"><h3 class="widget-title">',
					'after_title'	 => '</h3></div>',
				)
			);

			register_sidebar(
				array(
					'name'			 => esc_html__( 'Woocommerce Widget Area', 'beautypress' ),
					'id'			 => 'woocommerce-siderbar',
					'description'	 => esc_html__( 'Appears on woocommerce page.', 'beautypress' ),
					'before_widget'	 => '<div id="%1$s" class="beautypress-single-sidebar %2$s">',
					'after_widget'	 => '</div><!-- end widget -->',
					'before_title'	 => '<div class="beautypress-sidebar-heading"><h3 class="widget-title">',
					'after_title'	 => '</h3></div>',
				)
			);

			register_sidebar(
				array(
					'name'			 => esc_html__( 'Footer Widget', 'beautypress' ),
					'id'			 => 'footer-widget',
					'description'	 => esc_html__( 'Appears on posts and pages.', 'beautypress' ),
					'before_widget'	 => '<div class="footer-widget col-md-__xs-col-num__"><div id="%1$s" class="beautypress-single-footer-v2 %2$s">',
					'after_widget'	 => '</div></div>',
					'before_title'	 => '<h4 class="beautypress-footer-widget-title">',
					'after_title'	 => '</h4>',
				)
			);

			register_sidebar(
				array(
					'name'			 => esc_html__( 'Secondary Footer Widget', 'beautypress' ),
					'id'			 => 'secondary-footer-widget',
					'description'	 => esc_html__( 'Appears on posts and pages.', 'beautypress' ),
					'before_widget'	 => '<div class="footer-widget col-md-__xs-col-num__"><div id="%1$s" class="beautypress-single-footer-v2 %2$s">',
					'after_widget'	 => '</div></div>',
					'before_title'	 => '<h4 class="beautypress-footer-widget-title">',
					'after_title'	 => '</h4>',
				)
			);
		}
	}

	add_action( 'widgets_init', 'beautypress_widget_init' );
}

/**
 * Move comment field to bottom for better UI
 * @param array Comment $fields
 * @return type
 * Since v 1
 */
function beautypress_move_comment_field_to_bottom( $fields ) {
	$comment_field		 = $fields[ 'comment' ];
	unset( $fields[ 'comment' ] );
	$fields[ 'comment' ] = $comment_field;
	return $fields;
}

add_filter( 'comment_form_fields', 'beautypress_move_comment_field_to_bottom' );

/**
 * // Displsys search form.
 * @param string $form
 * @return string
 * Sincev 1
 */
function beautypress_search_form( $form ) {
	$form = '
        <form method="get" action="' . esc_url( home_url( '/' ) ) . '" id="search">
        	<div class="nav-search-inner">
                <input type="text" name="s" placeholder="' . __( 'Search..', 'beautypress' ) . '" value="' . get_search_query() . '">
            </div>
        </form>';
	return $form;
}

add_filter( 'get_search_form', 'beautypress_search_form' );

/**
 * // Header search form.
 * @param string $form
 * @return string
 * Sincev 1
 */
function beautypress_header_search_form( ) {
	$form = '
        <form method="get" action="' . esc_url( home_url( '/' ) ) . '" id="search">
                <input type="text" class ="form-control" name="s" placeholder="' . __( 'Search..', 'beautypress' ) . '" value="' . get_search_query() . '">
        </form>';
	return $form;
}

/**
 * Blog Next and previus post link modification hook
 * @param type $output
 * @return type
 */
function _beautypress_post_link_attributes( $output ) {
	$code = 'class="beautypress-btn next-and-prev-btn"';
	return str_replace( '<a href=', '<a ' . $code . ' href=', $output );
}

add_filter( 'next_post_link', '_beautypress_post_link_attributes' );
add_filter( 'previous_post_link', '_beautypress_post_link_attributes' );


add_action( 'customize_preview_init', 'beautypress_custmizer_live_preview' );

function beautypress_custmizer_live_preview(){

	wp_enqueue_script( 'beautypress-customizer', BEAUTYPRESS_SCRIPTS . '/customizer.js', array('jquery','customize-preview'), '',TRUE );
}

add_filter( 'dynamic_sidebar_params','footer_widgets_params',9,1);

function footer_widgets_params( $params ) {
	if ( 'footer-widget' === $params[0]['id'] ) {
		$params[0]['before_widget'] = str_replace( '__xs-col-num__', beautypress_option( 'footer_widget_layout',12), $params[0]['before_widget'] );
	}
	return $params;
}