<?php
if ( !defined( 'ABSPATH' ) )
	die( 'Direct access forbidden.' );
/**
 * Helper functions used all over the theme
 */


/*
 * Function for color RGB
 */

function beautypress_color_rgb( $hex ) {
	$hex		 = preg_replace( "/^#(.*)$/", "$1", $hex );
	$rgb		 = array();
	$rgb[ 'r' ]	 = hexdec( substr( $hex, 0, 2 ) );
	$rgb[ 'g' ]	 = hexdec( substr( $hex, 2, 2 ) );
	$rgb[ 'b' ]	 = hexdec( substr( $hex, 4, 2 ) );

	$color_hex = $rgb[ "r" ] . ", " . $rgb[ "g" ] . ", " . $rgb[ "b" ];

	return $color_hex;
}

/*
 * Section Edit option
 *
 * This function for show section edit option in every section in one page
 * @since 1.0.0
 *
 */

function beautypress_edit_section() {
	?>
	<div class="section-edit">
		<div class="container relative">
			<?php
			if ( is_user_logged_in() ) {
				edit_post_link( esc_html__( 'Edit', 'beautypress' ), '', '' );
			}
			?>
			<span class="section-abc"><?php echo esc_html( get_the_title() ); ?></span>
		</div>
	</div>
	<?php
}



/*
* Elementor ID
*/
 if ( !defined( 'ELEMENTOR_PARTNER_ID' ) ) {
define( 'ELEMENTOR_PARTNER_ID', 2144 );
}


/*
 * WP Kses Allowed HTML Tags Array in function
 * @Since Version 1.0.0
 * @param ar
 * Use: beautypress_kses($raw_string);
 * */

function beautypress_kses( $raw ) {

	$allowed_tags = array(
		'a'								 => array(
			'class'	 => array(),
			'href'	 => array(),
			'rel'	 => array(),
			'title'	 => array(),
		),
		'abbr'							 => array(
			'title' => array(),
		),
		'b'								 => array(),
		'blockquote'					 => array(
			'cite' => array(),
		),
		'cite'							 => array(
			'title' => array(),
		),
		'code'							 => array(),
		'del'							 => array(
			'datetime'	 => array(),
			'title'		 => array(),
		),
		'dd'							 => array(),
		'div'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'dl'							 => array(),
		'dt'							 => array(),
		'em'							 => array(),
		'h1'							 => array(),
		'h2'							 => array(),
		'h3'							 => array(),
		'h4'							 => array(),
		'h5'							 => array(),
		'h6'							 => array(),
		'i'								 => array(
			'class' => array(),
		),
		'img'							 => array(
			'alt'	 => array(),
			'class'	 => array(),
			'height' => array(),
			'src'	 => array(),
			'width'	 => array(),
		),
		'li'							 => array(
			'class' => array(),
		),
		'ol'							 => array(
			'class' => array(),
		),
		'p'								 => array(
			'class' => array(),
		),
		'q'								 => array(
			'cite'	 => array(),
			'title'	 => array(),
		),
		'span'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'strike'						 => array(),
		'br'							 => array(),
		'strong'						 => array(),
		'data-wow-duration'				 => array(),
		'data-wow-delay'				 => array(),
		'data-wallpaper-options'		 => array(),
		'data-stellar-background-ratio'	 => array(),
		'ul'							 => array(
			'class' => array(),
		),
	);

	if ( function_exists( 'wp_kses' ) ) { // WP is here
		$allowed = wp_kses( $raw, $allowed_tags );
	} else {
		$allowed = $raw;
	}



	return $allowed;
}

if ( !function_exists( 'beautypress_get_breadcrumbs' ) ) {

	// breadcrumbs
	function beautypress_get_breadcrumbs( $seperator ) {
		echo '<ul class="beautypress-breadcrumb">';
		if ( !is_front_page()) {
			echo '<li><a href="';
			echo esc_url( get_home_url( '/' ) );
			echo '">';
			echo esc_html__( 'Home', 'beautypress' );
			echo "</a></li> " . esc_attr( $seperator );
			if ( is_category() || is_single() ) {
				echo '<li>';
				$category	 = get_the_category();
				$post		 = get_queried_object();
				$postType	 = get_post_type_object( get_post_type( $post ) );
				if ( !empty( $category ) ) {
					echo esc_html( $category[ 0 ]->cat_name ) . '</li>';
				} else if ( $postType ) {
					echo esc_html( $postType->labels->singular_name ) . '</li>';
				}

				if ( is_single() ) {
					echo esc_attr( $seperator ) . "  <li>";
					echo wp_trim_words( get_the_title(), 3 );
					echo '</li>';
				}
			} elseif ( is_page() ) {
				echo '<li>';
				echo wp_trim_words( get_the_title(), 3 );
				echo '</li>';
			}
		}
		if ( is_tag() ) {
			single_tag_title();
		} elseif ( is_day() ) {
			echo"<li>" . __( 'Blogs for', 'beautypress' ) . " ";
			the_time( 'F jS, Y' );
			echo'</li>';
		} elseif ( is_month() ) {
			echo"<li>" . __( 'Blogs for', 'beautypress' ) . " ";
			the_time( 'F, Y' );
			echo'</li>';
		} elseif ( is_year() ) {
			echo"<li>" . __( 'Blogs for', 'beautypress' ) . " ";
			the_time( 'Y' );
			echo'</li>';
		} elseif ( is_author() ) {
			echo"<li>" . __( 'Author Blogs', 'beautypress' );
			echo'</li>';
		} elseif ( isset( $_GET[ 'paged' ] ) && !empty( $_GET[ 'paged' ] ) ) {
			echo "<li>" . __( 'Blogs', 'beautypress' );
			echo'</li>';
		} elseif ( is_search() ) {
			echo"<li>" . __( 'Search Result', 'beautypress' );
			echo'</li>';
		} elseif ( is_404() ) {
			echo"<li>" . __( '404 Not Found', 'beautypress' );
			echo'</li>';
		}
		echo '</ul>';
	}
}

/**
 * Post Exceprt
 * @param type $length
 * @return int
 *
 */

function beautypress_custom_excerpt_length( $length ) {
	return 25;
}
add_filter( 'excerpt_length', 'beautypress_custom_excerpt_length', 999 );

/**
 *
 * Excerpt More Button
 * @since 1.0.0
 *
 */

function beautypress_custom_excerpt_more( $more ) {
	return '<a class="btn btn-primary"  href="' . get_permalink() . '" target="_blank">' . __( 'Read More', 'beautypress' ) . '</a>';
}
add_filter( 'excerpt_more', 'beautypress_custom_excerpt_more' );

/**
 *
 * Trim word
 * @since 1.0.0
 *
 */
function beautypress_excerpt( $num = 20 ) {

	$excerpt		 = get_the_excerpt();
	$trimmed_content = wp_trim_words( $excerpt, $num_words = $num, $more = null );

	echo beautypress_kses( $trimmed_content );
}

/**
 *
 * Site Icon
 * @since 1.0.0
 *
 */

if ( !function_exists( 'beautypress_get_header_icons' ) ) {

	function beautypress_get_header_icons() {

		if ( function_exists( 'wp_site_icon' ) && has_site_icon()) {
			wp_site_icon();
		}else{

			if(!empty(beautypress_option( 'xs_favicon'))){
				echo sprintf( '<link rel="icon" href="%s" sizes="32x32" />', esc_url(beautypress_option( 'xs_favicon')) );
			}
		}
	}

}

/**
 *
 * Load Goggle Font
 * @since 1.0.0
 *
 */


function beautypress_google_fonts_url() {
    $fonts_url = '';
    $font_families = array();
    $body_font = beautypress_get_option('global_fonts','primary_font','');
    $head_font = beautypress_get_option('global_fonts','heading_font','');
    if(!empty($body_font)){
        $body_families = isset($body_font['family']) ? $body_font['family'] : '';
        $body_variant = isset($body_font['variant']) ? $body_font['variant'] : '';
        $font_families[] = $body_families.":".$body_variant;
    }
    if(!empty($head_font)){
        $head_families = isset($head_font['family']) ? $head_font['family'] : '';
        $head_variant = isset($head_font['variant']) ? $head_font['variant'] : '';
        $font_families[] = $head_families.":".$head_variant;
    }

    $font_families[] = 'Montserrat:100,200,300,400,500,600,700|Niconne';
//    /xs_print($font_families);

    if ( $font_families)
    {
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) )
        );

        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }

    return esc_url_raw( $fonts_url );
}


/**
 *
 * Xs Get Meta option
 * @since 1.0.0
 *
 */

if ( ! function_exists( 'xs_post_get_meta' ) ) {
    function xs_post_get_meta( $post_id = '', $section_id = '', $meta_key = '', $default = '', $xs_default = '') {

    	if(defined('CS_ACTIVE_FRAMEWORK') && 'CS_ACTIVE_FRAMEWORK' == true){

	        if(!empty($post_id) && !empty($section_id)){
	            $meta = get_post_meta($post_id,$section_id, true);
	            if(is_array($meta) && count($meta) > 0){
	                if(!empty($meta[$meta_key]))
	                {
	                    return $meta[$meta_key];
	                }
	                else
	                {
	                    return ( ! empty( $default ) ) ? $default : null;
	                }
	            }else{
	                return ( ! empty( $default ) ) ? $default : null;
	            }
	        }else{

	            return ( ! empty( $default ) ) ? $default : null;
	        }
	    }else{

    		return $xs_default;
    	}

    }
}

/**
 *
 * Get customize option
 * @since 1.0.0
 *
 */

if ( ! function_exists( 'beautypress_option' ) ) {
  function beautypress_option( $option_name = '', $default = '' ) {
  	//if(defined('CS_ACTIVE_FRAMEWORK') && 'CS_ACTIVE_FRAMEWORK' == true){
	    $options = apply_filters( 'cs_get_customize_option', get_option( '_cs_customize_options' ), $option_name, $default );

	    if( ! empty( $option_name ) && ! empty( $options[$option_name] ) ) {
	      return $options[$option_name];
	    } else {
	      return ( ! empty( $default ) ) ? $default : null;
	    }
	//}
  }
}

/**
 *
 * Get option
 * @since 1.0.0
 *
 */

if ( ! function_exists( 'beautypress_get_option' ) ) {
  function beautypress_get_option( $group_name = '', $option_name = '', $default = '' ) {

    $options = apply_filters( 'cs_get_option', get_option( '_cs_options' ), $group_name, array() );
    if(!empty($group_name) && isset($options[$group_name])){
        $option = $options[$group_name];
        if(is_array($option) && $option_name != '' && isset($option[$option_name])){
            return $option[$option_name];
        }else{
            return ( ! empty( $default ) ) ? $default : null;
        }
    }else{
        return ( ! empty( $default ) ) ? $default : null;
    }

  }
}

/**
 *
 * Image Crop
 * @since 1.0.0
 *
 */


if ( class_exists( 'XS_Resize' ) ) {
	function xs_resize( $url, $width = false, $height = false, $crop = false ) {
		$fw_resize = XS_Resize::getInstance();
		$response  = $fw_resize->process( $url, $width, $height, $crop );
		return ( ! is_wp_error( $response ) && ! empty( $response['src'] ) ) ? $response['src'] : $url;
	}
}

/**
 *
 * Get Catagories/Taxonomies List
 * @since 1.0.0
 *
 */

function xs_category_list( $cat ){
    $query_args = array(
        'orderby'       => 'ID',
        'order'         => 'DESC',
        'hide_empty'    => 1,
        'taxonomy'      => $cat
    );

    $categories = get_categories( $query_args );
    $options = array( esc_html__('0', 'beautypress') => 'All Category');
    if(is_array($categories) && count($categories) > 0){
        foreach ($categories as $cat){
            $options[$cat->term_id] = $cat->name;
        }
        return $options;
    }
}

/**
 *
 * Get All All regiter menu
 * @since 1.0.0
 *
 */

if(!function_exists('beautypress_menu_list')){
    function beautypress_menu_list(){
        $options = array( esc_html__('--beautypress--', 'beautypress') => 'Select Menu');
        $navs = get_registered_nav_menus();
        if(is_array($navs) && count($navs) > 0){
            foreach ($navs as $key => $val){
                $options[$key] = $val;
            }
            return $options;
        }

    }
}

if ( !function_exists( 'beautypress_advanced_xs_font_styles' ) ) {

	function beautypress_advanced_xs_font_styles( $style ) {

		$font_styles = '';
		if(isset($style['family'])){
			$font_styles .= 'font-family:' . esc_attr( $style[ 'family' ] ) . ';';
		}

		if( isset($style['variant']) && $style['variant'] == 'regular' ){
			$font_styles .= 'font-weight:400;';
		}elseif(isset($style['variant']) && $style['variant'] != 'regular' ){
			$font_styles .= 'font-weight:'.$style['variant'].';';
		}

		return !empty( $font_styles ) ? $font_styles : '';
	}
}
/**
 *
 * Minify inline Css
 * @since 1.0.0
 */

if ( ! function_exists( 'beautypress_css_compress' ) ) {
  function beautypress_css_compress( $css ) {
    $css  = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $css );
    $css  = str_replace( ': ', ':', $css );
    $css  = str_replace( array( "\r\n", "\r", "\n", "\t", '  ', '    ', '    ' ), '', $css );
    return $css;
  }
}


/**
 *
 * Get Post thumbanail
 * @since 1.0
 *
 */

if(!function_exists('beautypress_post_thumbnail')){
    function beautypress_post_thumbnail(){

		$time = strtotime(get_the_date('',get_the_ID()));
        $date = date_i18n('d',$time);
        $month = date_i18n('M',$time);


        ?>
		<div class="beautypress-newsfeed-header beautypress-black-gradient-overlay">
			<?php
				if(has_post_thumbnail()):
					$thumbnail	 = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), '' );
					$img = xs_resize( $thumbnail[0], 350, 218 );
					//echo '<img src="'.esc_url($thumbnail[0]).'" alt="'.get_the_title().'">';
					echo '<img src="'.esc_url($img).'" alt="'.get_the_title().'">';
			?>
					<div class="beautypress-newsfeed-header-content">
						<div class="beautypress-newsfeed-img">
							<?php echo get_avatar(get_the_author_meta( 'ID' ), 50 );?>
							<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"><?php the_author(); ?></a>
						</div>
						<div class="beautypress-dates">
							<p class="bg-color-purple"><?php echo esc_html($date);?><strong><?php echo esc_html($month);?></strong></p>
						</div>
					</div>
				<?php endif; ?>
		</div>
        <?php
    }
}

/**
 *
 * Comment List Show
 * @since 1.0.0
 *
 */

if(!function_exists('beautypress_comment_listing')){
  function beautypress_comment_listing($comment, $args, $depth){
      $GLOBALS['comment'] = $comment;
      $avater = get_avatar_url($comment->comment_author_email);
      $like = get_comment_meta( $comment->comment_ID, '_xs_commentlike', true );
      $dislike = get_comment_meta( $comment->comment_ID, '_xs_commentdislike', true );
       ?>
      <li id="comment-<?php echo esc_attr($comment->comment_ID); ?>">
          <div class="singleCom">
              	<?php echo get_avatar(get_the_author_meta('ID'), 96); ?>
              	<div class="comHead">
	              	  <a href=""><?php echo get_comment_time(get_option( 'date_format' )); ?></a>
	              	  <div class="comAutReply">
	              	  	<a href=""><?php echo esc_html($comment->comment_author); ?></a>
	              	  </div>
              	</div>
              	<div class="commentsContents">
                      <?php comment_text(); ?>
                </div>
				<ul class="beautypress-socail-react">
					<li><a href="" data-comid="<?php echo esc_attr($comment->comment_ID); ?>" data-like="_xs_commentlike"" class="color-purple"><i class="far fa-thumbs-up"></i></a><span><?php echo (empty($like)) ? 0 : esc_html($like);?></span></li>
					<li><a href="" data-comid="<?php echo esc_attr($comment->comment_ID); ?>" data-like="_xs_commentdislike" class="color-purple"><i class="far fa-thumbs-down"></i></a><span><?php echo (empty($dislike)) ? 0 : esc_html($dislike);?></span></li>
					<li><?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?></li>
				</ul>
          </div>
       <?php
  }
}

function enable_mega_menu(){
	$wpmm_options = get_option('wpmm_options');
	if((is_array($wpmm_options)) && isset($wpmm_options['primary'])){
		return true;
	}else{
		return false;
	}
}

function beautypress_return( $s ) {
	return $s;
}

function beautypres_excerpt( $num = 20 ) {

	$excerpt		 = get_the_excerpt();
	$trimmed_content = wp_trim_words( $excerpt, $num_words		 = $num, $more			 = null );

	echo beautypress_kses( $trimmed_content );
}

function sassico_ekit_headers($format='html'){

    if(class_exists('ElementsKit_Lite')){
        $select = [];
        $args = array(
			'posts_per_page'   => -1,
			'post_type' => 'elementskit_template',
			'meta_key' => 'elementskit_template_type',
			'meta_value' => 'header'
        );
        $headers = get_posts($args);
        foreach($headers as $header) {
            $select[$header->ID ] = $header->post_title;
        }
        return $select;

    }
    return [];
}

function sassico_ekit_footers($format='html'){

    if(class_exists('ElementsKit_Lite')){
        $select = [];
        $args = array(
			'posts_per_page'   => -1,
			'post_type' => 'elementskit_template',
			'meta_key' => 'elementskit_template_type',
			'meta_value' => 'footer'
        );
        $headers = get_posts($args);
        foreach($headers as $header) {
            $select[$header->ID ] = $header->post_title;
        }
        return $select;

    }
    return [];
}


add_action('elementskit/template/before_header', function(){
	$preloder = beautypress_option('show_preloder');
	if($preloder): ?>
		<div id="preloader">
			<div class="preloader-window left-window"></div>
			<div class="preloader-window right-window"></div>
			<div class="preloader-content">
				<?php if(empty(beautypress_option('preloader_logo'))): ?>
					<img src="<?php echo BEAUTYPRESS_IMAGES ?>/prelaoder-logo.png" alt="<?php bloginfo( 'name' ); ?>">
				<?php else: ?>
					<?php
						$preloader_logo = beautypress_option( 'preloader_logo');
						$image = wp_get_attachment_image_src( $preloader_logo, 'full' );
						$preloader_logo = $image[0];
					?>
					<img src="<?php echo esc_url($preloader_logo);?>" alt="<?php bloginfo( 'name' ); ?>">
				<?php endif; ?>
				<h2><?php echo esc_html( beautypress_option( 'preloader_text') ) ?></h2>
			</div>
			<div class="spinner-block">
				<div class="spinner-eff spinner-eff-3">
					<div class="circle circle-1"></div>
					<div class="circle circle-2"></div>
					<div class="circle circle-3"></div>
				</div>
			</div>
		</div>
	<?php endif;
});

function xs_header_builder_kit(){
    if(!is_customize_preview()){
        return;
    }

    $header_settings       = beautypress_option('theme_header_default_settings');
    $header_builder_enable = beautypress_option('header_builder_enable');

    if($header_builder_enable=='yes'){
        $args = [
            'posts_per_page'   => -1,
            'orderby'          => 'id',
            'order'            => 'DESC',
            'post_status'      => 'publish',
            'post_type'        => 'elementskit_template',
            'meta_query' => [
                [
                    'key'     => 'elementskit_template_activation',
                    'value'   => 'yes',
                    'compare' => '=',
                ],
            ],
        ];
        $headers = get_posts($args);
        foreach($headers as $header){
            update_post_meta($header->ID, 'elementskit_template_activation', '');
        }
    }
}
add_action( 'wp_loaded', 'xs_header_builder_kit' );