<?php
/**
 * header.php
 *
 * The header for the theme.
 */
?>
<!DOCTYPE html>
<!--[if !IE]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->

    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<?php wp_head(); ?>
    </head>


    <body <?php body_class(); ?> data-spy="scroll" data-target=".navbar-collapse">

		<?php if(class_exists('Xs_Main')): ?>
			<?php $preloder = beautypress_option('show_preloder'); ?>
			<?php if($preloder): ?>
				<div id="preloader">
					<div class="preloader-window left-window"></div>
					<div class="preloader-window right-window"></div>
					<div class="preloader-content">
						<?php if(empty(beautypress_option('preloader_logo'))): ?>
							<img src="<?php echo BEAUTYPRESS_IMAGES ?>/prelaoder-logo.png" alt="<?php bloginfo( 'name' ); ?>">
						<?php else: ?>
							<?php
								$preloader_logo = beautypress_option( 'preloader_logo');
								$image = wp_get_attachment_image_src( $preloader_logo, 'full' );
								$preloader_logo = $image[0];
							?>
							<img src="<?php echo esc_url($preloader_logo);?>" alt="<?php bloginfo( 'name' ); ?>">
						<?php endif; ?>
						<h2><?php echo esc_html( beautypress_option( 'preloader_text') ) ?></h2>
					</div>
					<div class="spinner-block">
						<div class="spinner-eff spinner-eff-3">
							<div class="circle circle-1"></div>
							<div class="circle circle-2"></div>
							<div class="circle circle-3"></div>
						</div>
					</div>
				</div>
			<?php endif; ?>
		<?php endif; ?>
		<a class="menulogolink" data-logo="<?php echo beautypress_option( 'site_logo'); ?>"></a>
		<!-- Prelaoder end -->
	<?php
		// $show_page_header      = xs_post_get_meta(get_the_ID(),'_page_meta', '_page_header_status', '',false);
		$header_builder_enable = beautypress_option('header_builder_enable');
		$header_settings       = beautypress_option('xs_header_builder_select');
		if($header_builder_enable == 'true' && class_exists('ElementsKit_Lite') && $header_settings !== null){
			if(class_exists('\ElementsKit\Utils::render_elementor_content')){
				echo \ElementsKit\Utils::render_elementor_content($header_settings);
			}else{
				$elementor = \Elementor\Plugin::instance();
				echo \ElementsKit\Utils::render($elementor->frontend->get_builder_content_for_display( $header_settings ));
			}
		}else{
			get_template_part( 'content/content', 'nav' );
		}
	?>
