<?php
/**
 * functions.php
 *
 * The theme's functions and definitions.
 */
/**
 * 1.0 - Define constants. Current Version number & Theme Name.
 */
define( 'BEAUTYPRESS_THEME', 'Beautypress');
define( 'BEAUTYPRESS_VERSION', '3.2' );
define( 'BEAUTYPRESS_THEMEROOT', get_template_directory_uri() );
define( 'BEAUTYPRESS_THEMEROOT_DIR', get_template_directory() );
define( 'BEAUTYPRESS_IMAGES', BEAUTYPRESS_THEMEROOT . '/assets/img' );
define( 'BEAUTYPRESS_IMAGES_DIR', BEAUTYPRESS_THEMEROOT_DIR . '/assets/img' );
define( 'BEAUTYPRESS_IMAGES_DIR_URI', BEAUTYPRESS_THEMEROOT . '/assets/img' );
define( 'BEAUTYPRESS_CSS', BEAUTYPRESS_THEMEROOT . '/assets/css' );
define( 'BEAUTYPRESS_CSS_DIR', BEAUTYPRESS_THEMEROOT_DIR . '/assets/css' );
define( 'BEAUTYPRESS_SCRIPTS', BEAUTYPRESS_THEMEROOT . '/assets/js' );
define( 'BEAUTYPRESS_SCRIPTS_DIR', BEAUTYPRESS_THEMEROOT_DIR . '/assets/js' );
define( 'BEAUTYPRESS_INC', BEAUTYPRESS_THEMEROOT_DIR . '/inc' );
define( 'BEAUTYPRESS_SHORTCODE_DIR', BEAUTYPRESS_INC . '/shortcode/' );
define( 'BEAUTYPRESS_SHORTCODE_DIR_STYLE', BEAUTYPRESS_INC . '/shortcode/style' );
define( 'BEAUTYPRESS_INSTALLATION', BEAUTYPRESS_THEMEROOT_DIR . '/installation-fragments' );
define( 'BEAUTYPRESS_REMOTE_CONTENT', esc_url('http://wp.xpeedstudio.com/demo-content/beautypress') );
define( 'BEAUTYPRESS_GLOBAL_UNYSON', esc_url('https://demo.xpeedstudio.com/global-plugin') );
/**
 * ----------------------------------------------------------------------------------------
 * 3.0 - Set up the content width value based on the theme's design.
 * ----------------------------------------------------------------------------------------
 */
if ( !isset( $content_width ) ) {
	$content_width = 800;
}


/**
 * ----------------------------------------------------------------------------------------
 * 4.0 - Set up theme default and register various supported features.
 * ----------------------------------------------------------------------------------------
 */
if ( !function_exists( 'beautypress_setup' ) ) {

	function beautypress_setup() {
		/**
		 * Make the theme available for translation.
		 */
		$lang_dir = BEAUTYPRESS_THEMEROOT . '/languages';
		load_theme_textdomain( 'beautypress', $lang_dir );

		/**
		 * Add support for post formats.
		*/

		add_theme_support( 'post-formats', array()
		);

		/**
		 * Add support for automatic feed links.
		 */
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );


		/**
		 * Add support for post thumbnails.
		 */
		add_theme_support( 'post-thumbnails' );

		add_image_size( 'beautypress-blog-thumb', 750, 462, TRUE );



		/**
		 * Register nav menus.
		 */
		register_nav_menus(
		array(
			'primary' => esc_html__( 'Main Menu', 'beautypress' ),
			'footer' => esc_html__( 'Footer Menu', 'beautypress' )
		)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
		) );

        add_theme_support('woocommerce');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
		add_theme_support( 'align-wide' );
	}

	add_action( 'after_setup_theme', 'beautypress_setup' );
}

// license 
require_once( BEAUTYPRESS_INC . '/libs/theme-license-manager/theme-license-manager.php');
$store_url = "https://xpeedstudio.com/";
$product_id = 8040;
\Theme\License\Theme_License_Manager::instance()->run( $store_url, $product_id );

/**
 * ----------------------------------------------------------------------------------------
 * 7.0 - theme INC.
 * ----------------------------------------------------------------------------------------
 */
include_once get_template_directory() . '/inc/init.php';

if( !file_exists( plugins_url(  "beautypress-features/cs-framework/cs-framework.php" ) ) ) {
	include_once get_template_directory() . '/cs-framework/cs-framework.php';
}




// Add this to your theme functions.php file. Change sidebar id to your primary sidebar id.
function beautypress_body_classes( $classes ) {

    if ( is_active_sidebar( 'sidebar-1' ) || ( class_exists( 'Woocommerce' ) && ! is_woocommerce() ) || class_exists( 'Woocommerce' ) && is_woocommerce() && is_active_sidebar( 'shop-sidebar' ) ) {
        $classes[] = 'sidebar-active';
    }else{
        $classes[] = 'sidebar-inactive';
    }
    return $classes;
}
add_filter( 'body_class','beautypress_body_classes' );

add_action('enqueue_block_editor_assets', 'beautypress_action_enqueue_block_editor_assets' );
function beautypress_action_enqueue_block_editor_assets() {
    wp_enqueue_style( 'beautypress-fonts', beautypress_google_fonts_url(['Montserrat:400,500,600,700,800,900']), null, BEAUTYPRESS_VERSION );
    wp_enqueue_style( 'beautypress-gutenberg-editor-font-awesome-styles', BEAUTYPRESS_CSS . '/font-awesome.min.css', null, BEAUTYPRESS_VERSION );
    wp_enqueue_style( 'beautypress-gutenberg-editor-customizer-styles', BEAUTYPRESS_CSS . '/gutenberg-editor-custom.css', null, BEAUTYPRESS_VERSION );
    wp_enqueue_style( 'beautypress-gutenberg-editor-styles', BEAUTYPRESS_CSS . '/gutenberg-custom.css', null, BEAUTYPRESS_VERSION );
    wp_enqueue_style( 'beautypress-gutenberg-blog-styles', BEAUTYPRESS_CSS . '/blog.css', null, BEAUTYPRESS_VERSION );
}