<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// CUSTOMIZE SETTINGS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options  = array();

/**
 *
 * Header Setting
 *
 */
$options[] = array(
    'name'              => 'genarel_settings',
    'title' => esc_html__('Genarel Settings', 'beautypress'),
    'settings'          => array(
          array(
                  'name'          => 'site_logo',
                  'control'       => array(
                      'type'      => 'upload',
                      'label'     => 'Logo',
                  ),
          ),

          array(
                  'name'          => 'site_mobile_logo',
                  'control'       => array(
                      'type'      => 'upload',
                      'label'     => 'Mobile Logo',
                  ),
          ),

          array(
            
                  'name'          => 'xs_favicon',
                  'control'       => array(
                      'type'      => 'image',
                      'label'     => 'Favicon',
                  ),
          ),
          array(
                  'name'          => 'gmap_api',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Gmap API Settings','beautypress'),
                      ),
                  ),
          ),

          array(
                  'name'          => 'show_social',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'switcher',
                          'title'     => esc_html__('Show social Icon?','beautypress'),
                          'dependency'   => array( 'header_style', 'any', 'header2,header3,header5' ),
                      ),
                  ),
                  'default' => false,
          ),

          array(

                  'name'          => 'header_fb',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Facebook','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('#','beautypress'),
          ),

          array(

                  'name'          => 'header_tw',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Twitter','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('#','beautypress'),
          ),

          array(

                  'name'          => 'header_dr',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Dribbble','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('#','beautypress'),
          ),

          array(

                  'name'          => 'header_gplus',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Google plus','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('#','beautypress'),
          ),

          array(

                  'name'          => 'header_insta',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('instagram','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('#','beautypress'),
          ),


          array(
                  'name'          => 'show_preloder',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'switcher',
                          'title'     => esc_html__('Show Preloader?','beautypress'),
                      ),
                  ),
                  'default' => true,
          ),

          array(
            
                  'name'          => 'preloader_logo',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'image',
                          'title'     => esc_html__('Preloader Image','beautypress'),
                          'dependency'   => array( 'show_preloder', '==', 'true' ),
                      ),
                  ),
          ),

          array(

                  'name'          => 'preloader_text',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Preloader Text','beautypress'),
                          'dependency'   => array( 'show_preloder', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('BeautyPress','beautypress'),
          ),

    )
);
$options[] = array(
    'name'              => 'header_settings',
    'title' => esc_html__('Header Settings', 'beautypress'),
    'settings'          => array(

          array(
                'name'          => 'header_style',
                'control'       => array(
                    'type'        => 'cs_field',
                    'options'     => array(
                        'type'      => 'image_select',
                        'title'     => 'Header Style',
                        'options'   => array(
                            'header1' => BEAUTYPRESS_IMAGES_DIR_URI.'/admin/header/header_1_menu.jpg',
                            'header2' => BEAUTYPRESS_IMAGES_DIR_URI.'/admin/header/header_3_menu.jpg',
                            'header3' => BEAUTYPRESS_IMAGES_DIR_URI.'/admin/header/header_2_menu.jpg',
                            'header4' => BEAUTYPRESS_IMAGES_DIR_URI.'/admin/header/header_4_menu.jpg',
                            'header5' => BEAUTYPRESS_IMAGES_DIR_URI.'/admin/header/header_5_menu.jpg',
                        ),
                        'attributes'   => array(
                              'data-depend-id' => 'header_style',
                        ),
                        'radio'     => true,
                    ),
                ),
                'default' => 'header1',
          ),

          array(
                  'name'          => 'menu_bg_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => esc_html__('Navigation Background Color','beautypress'),
                      ),
                  ),
                  'default' => ''
          ),

          array(
                  'name'          => 'menu_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => esc_html__('Navigation Color','beautypress'),
                      ),
                  ),
                  'default' => '#ffffff'
          ),

          array(
                  'name'          => 'menu_hover_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => esc_html__('Navigation Hover Color','beautypress'),
                      ),
                  ),
                  'default' => '#6A1B9A'
          ),

          array(
                  'name'          => 'sub_menu_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => esc_html__('Navigation Sub Menu Color','beautypress'),
                      ),
                  ),
                  'default' => '#222222'
          ),

          array(
                  'name'          => 'sub_menu_hover_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => esc_html__('Navigation Sub Menu Hover Color','beautypress'),
                      ),
                  ),
                  'default' => '#ffffff'
          ),
          
          array(
                  'name'          => 'show_search',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'switcher',
                          'title'     => esc_html__('Show Search Icon?','beautypress'),
                          'dependency'   => array( 'header_style', '==', 'header2' ),
                      ),
                  ),
                  'default' => true,
          ),

          array(
                'name'          => 'xs_top_head',
                'control'       => array(
                    'type'      => 'cs_field',
                    'options'   =>  array(
                        'type'      => 'heading',
                        'content'     => esc_html__('Top Header Section','beautypress'),
                    ),
                ),
          ),

          array(
                  'name'          => 'show_top_header',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'switcher',
                          'title'     => esc_html__('Show Top Header?','beautypress'),
                      ),
                  ),
                  'default' => true,
          ),

          array(

                  'name'          => 'header_phn',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Phone Number','beautypress'),
                          'dependency'   => array( 'show_top_header', '==', 'true' ),
                      ),
                  ),
                  'default' =>  '+00 00 11 22 33'
          ),

          array(

                  'name'          => 'header_email',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Email Address','beautypress'),
                          'dependency'   => array( 'show_top_header', '==', 'true' ),
                      ),
                  ),
                  'default' =>  'info@xpeedstudio.com'
          ),

          array(
                  'name'          => 'top_head_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => 'Top Header Text Color',
                          'dependency'   => array( 'show_top_header', '==', 'true' ),
                      ),
                  ),
                  'default' =>  '#ffffff',
          ),

          array(
                  'name'          => 'top_head_bg_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => 'Top Header Background Color',
                          'dependency'   => array( 'show_top_header', '==', 'true' ),
                      ),
                  ),
                  'default' =>  '',
          ),

          array(
                  'name'          => 'show_social',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'switcher',
                          'title'     => esc_html__('Show social Icon?','beautypress'),
                          'dependency'   => array( 'header_style', 'any', 'header2,header3,header5' ),
                      ),
                  ),
                  'default' => false,
          ),

          array(

                  'name'          => 'header_fb',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Facebook','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('','beautypress'),
          ),

          array(

                  'name'          => 'header_tw',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Twitter','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('','beautypress'),
          ),

          array(

                  'name'          => 'header_dr',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Dribbble','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('','beautypress'),
          ),

          array(

                  'name'          => 'header_gplus',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('Google plus','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('','beautypress'),
          ),

          array(

                  'name'          => 'header_insta',
                  'control'       => array(
                      'type'      => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'text',
                          'title'     => esc_html__('instagram','beautypress'),
                          'dependency'   => array( 'show_social', '==', 'true' ),
                      ),
                  ),
                  'default' =>  esc_html__('','beautypress'),
          ),


    )
);

/**
 *
 * Blog Settings
 *
 */
$options[] = array(
    'name'              => 'blog_settings',
    'title' => esc_html__('Blog Settings', 'beautypress'),
    'settings'          => array(

          array(
                  'name'          => 'show_blog_header',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'switcher',
                          'title'     => esc_html__('Show Banner?','beautypress'),
                      ),
                  ),
                  'default' => true,
          ),

          array(
            
                  'name'          => 'blog_header_banner',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'   =>  array(
                          'type'      => 'image',
                          'title'     => esc_html__('Banner Image','beautypress'),
                          'dependency'   => array( 'show_blog_header', '==', 'true' ),
                      ),
                  ),
          ),

          array(
                  'name'          => 'blog_header_overlay',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => esc_html__('Overlay Background Color','beautypress'),
                          'dependency'   => array( 'show_blog_header', '==', 'true' ),
                      ),
                  ),
                  'default' =>  'rgba(0, 0, 0, 0.5)',
          ),

          array(

                  'name'          => 'blog_title',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'      => 'text',
                      'label'     => esc_html__('Blog Page Title','beautypress'),
                  ),
          ),

          array(

                  'name'          => 'blog_sub_title',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'      => 'textarea',
                      'label'     => esc_html__('Blog Page Sub Title','beautypress'),
                  ),
          ),

          array(

                  'name'          => 'element_per_row',
                  'default'       =>  4,
                  'control'       => array(
                      'label'     => esc_html__('Post Element Per Row','beautypress'),
                      'type'      => 'select',
                      'choices'   => array(
                          '6'      => esc_html__('2 Element','beautypress'),
                          '4'      => esc_html__('3 Element','beautypress'),
                          '3'      => esc_html__('4 Element','beautypress'),
                      ),
                  ),
          ),

          array(

                  'name'          => 'blog_sidebar',
                  'default'       =>  1,
                  'control'       => array(
                      'label'     => esc_html__('Blog Sidebar Position','beautypress'),
                      'type'      => 'select',
                      'choices'   => array(
                          '1'      => esc_html__('Full Width','beautypress'),
                          '2'      => esc_html__('Left Sidebar','beautypress'),
                          '3'      => esc_html__('Right Sidebar','beautypress'),
                      ),
                  ),
          ),

          array(
                  'name'          => 'show_blog_breadcrumb',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'switcher',
                          'title'     => esc_html__('Show Breadcrumb?','beautypress'),
                      ),
                  ),
                  'default' => true,
          ),
    )
);

/**
 *
 * Single Blog Settings
 *
 */
$options[] = array(
    'name'              => 'single_blog_settings',
    'title' => esc_html__('Single Blog Settings', 'beautypress'),
    'settings'          => array(


          array(

                  'name'          => 'single_blog_sidebar',
                  'default'       =>  1,
                  'control'       => array(
                      'label'     => esc_html__('Post Sidebar Position','beautypress'),
                      'type'      => 'select',
                      'choices'   => array(
                          '1'      => esc_html__('Full Width','beautypress'),
                          '2'      => esc_html__('Left Sidebar','beautypress'),
                          '3'      => esc_html__('Right Sidebar','beautypress'),
                      ),
                  ),
          ),
          array(
                  'name'          => 'blog_single_overlay',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => esc_html__('Overlay Background Color','beautypress'),
                      ),
                  ),
                  'default' =>  'rgba(0, 0, 0, 0.5)',
          ),
    )
);

/**
 *
 * Page Setting
 *
 */

$options[] = array(
    'name'              => 'page_settings',
    'title' => esc_html__('Page Settings', 'beautypress'),
    'settings'          => array(

          array(

                  'name'          => 'page_sidebar',
                  'default'       =>  1,
                  'control'       => array(
                      'label'     => esc_html__('Blog Sidebar Position','beautypress'),
                      'type'      => 'select',
                      'choices'   => array(
                          '1'      => esc_html__('Full Width','beautypress'),
                          '2'      => esc_html__('Left Sidebar','beautypress'),
                          '3'      => esc_html__('Right Sidebar','beautypress'),
                      ),
                  ),
          ),

          array(
                  'name'          => 'show_page_breadcrumb',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'switcher',
                          'title'     => esc_html__('Show Breadcrumb?','beautypress'),
                      ),
                  ),
                  'default' => true,
          ),
    )
);

/**
 *
 * Footer Settings
 *
 */

$options[] = array(
    'name'              => 'footer_settings',
    'title' => esc_html__('Footer Settings', 'beautypress'),
    'sections'          => array(

        //Footer primary Section
        array(
              'name'          => 'footer_primary_section',
              'title'         => 'Primary Footer',
              'settings'      => array(

                  array(
                        'name'          => 'footer_style',
                        'control'       => array(
                            'type'        => 'cs_field',
                            'options'     => array(
                                'type'      => 'image_select',
                                'title'     => 'Footer Style',
                                'options'   => array(
                                    'footer-1' => BEAUTYPRESS_IMAGES_DIR_URI.'/admin/footer/index_1_foter.jpg',
                                    'footer-2' => BEAUTYPRESS_IMAGES_DIR_URI.'/admin/footer/index_2_foter.jpg',
                                    //'footer-3' => BEAUTYPRESS_IMAGES_DIR_URI.'/admin/footer/index_3_foter.jpg',
                                ),
                                'attributes'   => array(
                                      'data-depend-id' => 'footer_style',
                                ),
                                'radio'     => true,
                            ),
                        ),
                        'default' => 'footer-1',
                  ),

                  array(
                          'name'          => 'footer_logo',
                          'control'       => array(
                              'type'      => 'upload',
                              'label'     => 'Logo',
                          ),
                  ),

                  array(
                            'name'          => 'footer_widget_layout',
                            'control'       => array(
                                'type'      => 'cs_field',
                                'options'   =>  array(
                                    'title'     => esc_html__('Footer Widget Per Row','beautypress'),
                                    'type'      => 'select',
                                    'desc'      =>  esc_html__('Select number of widget you want in the footer','beautypress'),
                                    //'dependency' => array( 'footer_style', '==', 'footer-2' ),
                                    'options'   => array(
                                          12 => 1,
                                          6 => 2,
                                          4 => 3,
                                          3 => 4,
                                    ),
                                ),
                            ),
                            'default'   => 12,
                    ),

                    array(
                            'name'          => 'show_subscribe',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'switcher',
                                    'title'     => esc_html__('Show Subscribe Form?','beautypress'),
                                    'dependency'   => array( 'footer_style', '==', 'footer-1' ),
                                ),
                            ),
                            'default' => true,
                    ),

                    array(
                            'name'          => 'subscribe_form_title',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'text',
                                    'title'     => esc_html__('Subscribe Form Title','beautypress'),
                                    'dependency' => array( 'footer_style|show_subscribe', '==|==', 'footer-1|true' ),
                                ),
                            ),
                            'default' => esc_html__( 'Subscribe For More Updates','beautypress' ),
                    ),

                    array(
                            'name'          => 'mailchimp_url',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'textarea',
                                    'title'     => esc_html__('Subscribe Form Url','beautypress'),
                                    'desc'     => esc_html__('Enter You Mailchimp From Url','beautypress'),
                                    'dependency' => array( 'footer_style|show_subscribe', '==|==', 'footer-1|true' ),
                                ),
                            ),
                            'default' => esc_html__( 'Subscribe For More Updates','beautypress' ),
                    ),

                    array(
                            'name'          => 'bg_color_one',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'color_picker',
                                    'title'     => 'Background Color',
                                    'rgba'    => true,
                                    'desc'      => 'After save you can see this background color.',
                                    'dependency' => array( 'footer_style', '==', 'footer-1' ),
                                ),
                            ),
                    ),

                    array(
                      
                            'name'          => 'show_menu',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'switcher',
                                    'title'     => esc_html__('Show Footer Menu','beautypress'),
                                ),
                            ),
                            'default' => false,
                    ),

                    array(
                      
                            'name'          => 'show_secondary_footer',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'switcher',
                                    'title'     => esc_html__('Show Secondary Footer','beautypress'),
                                    'dependency' => array( 'footer_style', '==', 'footer-2' ),
                                ),
                            ),
                            'default' => false,
                    ),
                   
                    array(
                            'name'          => 'xs_head',
                            'control'       => array(
                                'type'      => 'cs_field',
                                'options'   =>  array(
                                    'type'      => 'heading',
                                    'content'     => esc_html__('Styling Section','beautypress'),
                                ),
                            ),
                    ),

                    array(
                            'name'          => 'footer2_bg',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'color_picker',
                                    'title'     => 'Footer Background Color',
                                    'rgba'      => true,
                                    'desc'      => 'please select your background color',
                                    'dependency' => array( 'footer_style', '==', 'footer-2' ),
                                ),
                            ),
                            'default' => '#000'
                    ),

                    array(
                            'name'          => 'footer_widget_color',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'color_picker',
                                    'title'     => 'Widget Title Color',
                                    //'dependency' => array( 'footer_style', 'any', 'footer-1,footer-2' ),
                                ),
                            ),
                            'default' => '#ffffff'
                    ),

                    array(
                            'name'          => 'footer_color',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'color_picker',
                                    'title'     => 'Footer Text Color',
                                    //'dependency' => array( 'footer_style', 'any', 'footer-1,footer-2' ),
                                ),
                            ),
                            'default' => '#fff',
                    ),

                    array(
                            'name'          => 'footer_link_color',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'color_picker',
                                    'title'     => 'Footer Link Color',
                                    //'dependency' => array( 'footer_style', 'any', 'footer-1,footer-2' ),
                                ),
                            ),
                            'default' => '#7531A1',
                    ),

                    array(
                            'name'          => 'footer_menu_color',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'color_picker',
                                    'title'     => 'Footer Menu Color',
                                    'rgba'      => true,
                                    'desc'      => 'please select your google plus  icon color',
                                    //'dependency' => array( 'footer_style', '==', 'footer-2' ),
                                ),
                            ),
                            'default' => '#ffffff',
                    ),

                    array(
                            'name'          => 'footer_menu_hover_color',
                            'transport'     => 'postMessage',
                            'control'       => array(
                                'type'        => 'cs_field',
                                'options'     => array(
                                    'type'      => 'color_picker',
                                    'title'     => 'Footer Menu Hover Color',
                                    'rgba'      => true,
                                    'desc'      => 'please select your google plus  icon color',
                                    //'dependency' => array( 'footer_style', '==', 'footer-2' ),
                                ),
                            ),
                            'default' => '#7531A1',
                    ),
              ),
        ),

        //Copyright Section
        
        array(
              'name'          => 'footer_copyright_section',
              'title'         => 'Footer Copyright',
              'settings'      => array(
                  array(

                          'name'          => 'footer_copyright',
                          'transport'     => 'postMessage',
                          'control'       => array(
                              'type'      => 'cs_field',
                              'options'   =>  array(
                                  'type'      => 'textarea',
                                  'title'     => esc_html__('CopyRight Text','beautypress'),
                              ),
                          ),
                          'default' =>  esc_html__('XpeedStudio © 2017 All Rights Reserved Terms of Use and Privacy Policy','beautypress' )
                  ),

                  array(
                          'name'          => 'footer_copy_color',
                          'transport'     => 'postMessage',
                          'control'       => array(
                              'type'        => 'cs_field',
                              'options'     => array(
                                  'type'      => 'color_picker',
                                  'title'     => 'Text Color',
                                  //'dependency' => array( 'footer_style', 'any', 'footer-1,footer-2' ),
                              ),
                          ),
                  ),

                  array(
                          'name'          => 'footer_copy_link_color',
                          'transport'     => 'postMessage',
                          'control'       => array(
                              'type'        => 'cs_field',
                              'options'     => array(
                                  'type'      => 'color_picker',
                                  'title'     => 'Link Color',
                                  //'dependency' => array( 'footer_style', 'any', 'footer-1,footer-2' ),
                              ),
                          ),
                  ),

                  array(
                          'name'          => 'footer_copy_bg_color',
                          'transport'     => 'postMessage',
                          'control'       => array(
                              'type'        => 'cs_field',
                              'options'     => array(
                                  'type'      => 'color_picker',
                                  'title'     => esc_html__('Background Color','beautypress')
                                  //'dependency' => array( 'footer_style', 'any', 'footer-1,footer-2' ),
                              ),
                          ),
                  ),

                  array(

                        'name'          => 'xs_head_copyright',
                        'control'       => array(
                            'type'      => 'cs_field',
                            'options'   =>  array(
                                'type'      => 'heading',
                                'content'     => esc_html__('Back to Top Section','beautypress'),
                            ),
                        ),
                  ),

                  array(
                          'name'          => 'footer_back_to_color',
                          'transport'     => 'postMessage',
                          'control'       => array(
                              'type'        => 'cs_field',
                              'options'     => array(
                                  'type'      => 'color_picker',
                                  'title'     => esc_html__('Icon Color','beautypress'),
                              ),
                          ),
                  ),

                  array(
                          'name'          => 'footer_back_to_bg_color',
                          'transport'     => 'postMessage',
                          'control'       => array(
                              'type'        => 'cs_field',
                              'options'     => array(
                                  'type'      => 'color_picker',
                                  'title'     => esc_html__('Icon Background Color','beautypress'),
                              ),
                          ),
                  ),
              ),
        ),
 
    )
);

/**
 *
 * 404 Settings
 *
 */

$options[] = array(
    'name'              => '404_settings',
    'title' => esc_html__('404 Settings', 'beautypress'),
    'settings'          => array(
        
          array(
                  'name'          => '404_text',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'text',
                          'title'     => esc_html__('Title','beautypress'),
                      ),
                  ),
                  'default' => esc_html__( 'Uh Oh! Looks Like Something Broken','beautypress' ),
          ),

          array(
                  'name'          => '404_btn_label',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'text',
                          'title'     => esc_html__('Button Label','beautypress'),
                      ),
                  ),
                  'default' => esc_html__( 'BACK HOME','beautypress' ),
          ),

          array(
                  'name'          => '404_btn_link',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'text',
                          'title'     => esc_html__('Button Link','beautypress'),
                      ),
                  ),
                  'default' => esc_html__( '','beautypress' ),
          ),

          array(
                  'name'          => '404_btn_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => 'Button Background Color',
                      ),
                  ),
                  'default' =>  '#4CA14B',
          ),

          array(
                  'name'          => '404_btn_hover_color',
                  'transport'     => 'postMessage',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => 'Button Background Hover Color',
                      ),
                  ),
                  'default' =>  '#FF4641',
          ),
    )
);

$options[] = array(
    'name'              => 'color_scheme',
    'title' => esc_html__('Color Scheme', 'beautypress'),
    'settings'          => array(
        
          array(
                  'name'          => 'main_color',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => 'Primary Color',
                      ),
                  ),
          ),

          array(
                  'name'          => 'main_color_secondary',
                  'control'       => array(
                      'type'        => 'cs_field',
                      'options'     => array(
                          'type'      => 'color_picker',
                          'title'     => 'Secondary Color',
                      ),
                  ),
          ),
    )
);
CSFramework_Customize::instance( $options );