<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// METABOX OPTIONS
// -----------------------------------------------------------------------------------------------
// ===============================================================================================
$options      = array();
include_once get_template_directory() . '/cs-framework-override/config/demo-page-meta.php';
// -----------------------------------------
// Service Tabs Metabox Options                    -
// -----------------------------------------
$options[]      = array(
        'id'            => '_service_meta',
        'title'         => esc_html__('Services', 'beautypress'),
        'post_type'     => 'service',
        'context'       => 'normal',
        'priority'      => 'default',
        'sections'      => array(
                array(
                        'name'      => 'section_1',
                        'fields'    => array(
                                array(
                                      'id'              => 'service_image',
                                      'type'            => 'image',
                                      'title' => esc_html__('Image','beautypress'),
                                ),
                                array(
                                      'id'              => 'service_price',
                                      'type'            => 'text',
                                      'title' => esc_html__('Price','beautypress'),
                                ),
                                array(
                                      'id'              => 'service_content',
                                      'type'            => 'wysiwyg',
                                      'title' => esc_html__('Content','beautypress'),
                                      'settings' => array(
                                              'wpautop' => false,
                                      ),
                                ),
                                array(
                                      'id'              => 'service_btn_lable',
                                      'type'            => 'text',
                                      'title' => esc_html__('Button Lable','beautypress'),
                                ),
                                array(
                                      'id'              => 'service_btn_link',
                                      'type'            => 'text',
                                      'title' => esc_html__('Button Link','beautypress'),
                                ),
                                array(
                                  'id'       => 'service_link_target',
                                  'type'     => 'select',
                                  'title'    => esc_html__('Button Target','beautypress'),
                                  'options'  => array(
                                    '_self'  => 'Self',
                                    '_blank'   => 'Blank',
                                  ),
                                  'default'  => '_self',
                                ),
                        ),
                        
                ),
        ),
        
);

/**
 *
 * Page Section
 *
 */

$options[]      = array(
        'id'            => '_page_meta',
        'title'         => esc_html__('Banner Setting', 'beautypress'),
        'post_type'     => 'page',
        'context'       => 'normal',
        'priority'      => 'default',
        'sections'      => array(
                array(
                        'name'      => 'section_1',
                        'title'  => esc_html__('Page Setting', 'beautypress'),
                        'icon'   => 'fas fa-book',
                        'fields'    => array(

                              array(

                                    'id'     => 'show_banner',
                                    'type'   => 'switcher',
                                    'title'  => esc_html__('Show Banner','beautypress'),
                                    'default' => true,
                              ),

                              array(

                                    'id'     => 'banner_image',
                                    'type'   => 'image',
                                    'title'  => esc_html__('Banner Image','beautypress'),
                                    'dependency'  => array( 'show_banner', '==', 'true' ),  
                              ),


                              array(
                                    'id'              => 'banner_title',
                                    'type'            => 'text',
                                    'title' => esc_html__('Title','beautypress'),
                                    'dependency'  => array( 'show_banner', '==', 'true' ),
                              ),

                              array(
                                    'id'              => 'banner_sub_title',
                                    'type'            => 'textarea',
                                    'title' => esc_html__('Sub Title','beautypress'),
                                    'dependency'  => array( 'show_banner', '==', 'true' ),
                              ),
                        ),
                        
                ),
                get_meta_page_feild(false),
        ),
);

/**
 *
 * SIngle Post Section
 *
 */

$options[]      = array(
        'id'            => '_post_meta',
        'title'         => esc_html__('Banner Setting', 'beautypress'),
        'post_type'     => 'post',
        'context'       => 'normal',
        'priority'      => 'default',
        'sections'      => array(
                array(
                        'name'      => 'section_1',
                        'fields'    => array(

                              array(

                                    'id'     => 'show_banner',
                                    'type'   => 'switcher',
                                    'title'  => esc_html__('Show Banner','beautypress'),
                                    'default' => true,
                              ),

                              array(

                                    'id'     => 'banner_image',
                                    'type'   => 'image',
                                    'title'  => esc_html__('Banner Image','beautypress'),
                                    'dependency'  => array( 'show_banner', '==', 'true' ),  
                              ),

                              array(
                                    'id'              => 'banner_title',
                                    'type'            => 'text',
                                    'title' => esc_html__('Title','beautypress'),
                                    'dependency'  => array( 'show_banner', '==', 'true' ),
                              ),

                              array(
                                    'id'              => 'banner_sub_title',
                                    'type'            => 'textarea',
                                    'title' => esc_html__('Sub Title','beautypress'),
                                    'dependency'  => array( 'show_banner', '==', 'true' ),
                              ),
                        ),
                        
                ),
        ),
);

/**
 *
 * Portfolio Section
 *
 */

$options[]      = array(
        'id'            => '_folio_meta',
        'title'         => esc_html__('Portfolio', 'beautypress'),
        'post_type'     => 'xs-portfolio',
        'context'       => 'normal',
        'priority'      => 'default',
        'sections'      => array(
                array(
                        'name'      => 'section_1',
                        'fields'    => array(

                              array(
                                  'id'        => 'featured_image_size',
                                  'type'      => 'image_select',
                                  'title'     => 'Featured Image Size',
                                  'options'   => array(
                                      'image_one' => 'http://via.placeholder.com/100x100',
                                      'image_two' => 'http://via.placeholder.com/100x100',
                                      'image_three' => 'http://via.placeholder.com/100x100',
                                      'image_four' => 'http://via.placeholder.com/100x100',
                                    ),
                                    'attributes'   => array(
                                        'data-depend-id' => 'featured_image_size',
                                    ),
                                    'radio'     => true,
                                ),

                                array(

                                      'id'     => 'featured_image',
                                      'type'   => 'image',
                                      'title'  => esc_html__('Featured Image','beautypress'),
                                      'dependency'  => array( 'featured_image_size', '!=', '' ), 
                                ),

                                array(
                                      'id'              => 'portfolio_image_gallery',
                                      'type'            => 'gallery',
                                      'title' => esc_html__('Project Gellery','beautypress'),
                                ),

                                array(
                                      'id'              => 'skill',
                                      'type'            => 'textarea',
                                      'title' => esc_html__('Skill','beautypress'),
                                ),

                                array(
                                      'id'              => 'client_name',
                                      'type'            => 'text',
                                      'title' => esc_html__('Client Name','beautypress'),
                                ),

                                array(
                                      'id'              => 'project_link',
                                      'type'            => 'text',
                                      'title' => esc_html__('Project Link','beautypress'),
                                ),

                                array(
                                  'id'       => 'service_link_target',
                                  'type'     => 'select',
                                  'title'    => esc_html__('Button Target','beautypress'),
                                  'options'  => array(
                                    '_self'  => 'Self',
                                    '_blank'   => 'Blank',
                                  ),
                                  'default'  => '_self',
                                ),
                        ),
                        
                ),
        ),    
);


CSFramework_Metabox::instance( $options );
