<?php
/**
 * The template for displaying Comments
 *
 * The area of the page that contains comments and the comment form.
 *
 * @package Doors
 * @subpackage Doors
 * @since Doors 1.0
 */
/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div class="beautypress-replay-container">
	<div class="beautypress-replay-form-wraper">
		<div id="comments" class="comments-area">
			<div class="beautypress-simple-title mb-30">
				<h3><?php comments_number('0 Comment', '1 Comment', '% Comments'); ?> </h3>
			</div>
			<?php if ( have_comments() ) : ?>
				<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
					<nav id="comment-nav-above" class="navigation comment-navigation" role="navigation">
						<h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'beautypress' ); ?></h1>
						<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'beautypress' ) ); ?></div>
						<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'beautypress' ) ); ?></div>
					</nav><!-- #comment-nav-above -->
				<?php endif; // Check for comment navigation.  ?>
				<div class="commentList">
					<ol class="comment-list">
						<?php wp_list_comments(array('callback' => 'beautypress_comment_listing')); ?>
					</ol><!-- .comment-list -->
				</div>

				<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
					<nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
						<h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'beautypress' ); ?></h1>
						<div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'beautypress' ) ); ?></div>
						<div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'beautypress' ) ); ?></div>
					</nav><!-- #comment-nav-below -->
				<?php endif; // Check for comment navigation.  ?>

				<?php if ( !comments_open() ) : ?>
					<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'beautypress' ); ?></p>
				<?php endif; ?>

			<?php endif; ?>

			<?php
			$post_id = '';
			if ( null === $post_id )
				$post_id = get_the_ID();
			else
				$id		 = $post_id;

			$commenter		 = wp_get_current_commenter();
			$user			 = wp_get_current_user();
			$user_identity	 = $user->exists() ? $user->display_name : '';


			$req		 = get_option( 'require_name_email' );
			$aria_req	 = ( $req ? " aria-required='true'" : '' );

			$fields = array(
				'author' => '<div class="row mb-30"><div class="col-4"><div class="form-group"><input placeholder="'.esc_html__('Enter Name *','beautypress').'" id="author" class="comment-100" name="author" type="text" value="' . esc_attr( $commenter[ 'comment_author' ] ) . '" size="30"' . $aria_req . ' /></div></div>',
				'email'	 => '<div class="col-4"><div class="form-group"><input Placeholder="'.esc_html__('Enter Email *','beautypress').'" class="comment-50" id="email" name="email" type="email" value="' . esc_attr( $commenter[ 'comment_author_email' ] ) . '" size="30"' . $aria_req . ' /></div></div>',
				'url'	 => '<div class="col-4"><div class="form-group"><input Placeholder="'.esc_html__('Enter Website','beautypress').'"  class="comment-50" id="url" name="url" type="url" value="' . esc_attr( $commenter[ 'comment_author_url' ] ) . '" size="30" /></div></div></div>',
			);

			if ( is_user_logged_in() ) {
				$cl = 'loginformuser';
			} else {
				$cl = '';
			}
			$defaults = array(
				'fields'			 => $fields,
				'comment_field'		 => '<div class="form-group ' . $cl . '"><textarea  Placeholder="'.  esc_html__('Enter Comments ','beautypress').'*" class="form-control mb-30" id="comment" name="comment" cols="45" rows="8" aria-required="true"></textarea></div><div class="clearfix"></div>',
				/** This filter is documented in wp-includes/link-template.php */
				'must_log_in'		 => '<p class="must-log-in">' . sprintf( wp_kses_post( 'You must be <a href="%s">logged in</a> to post a comment.', 'beautypress' ), wp_login_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
				/** This filter is documented in wp-includes/link-template.php */
				'logged_in_as'		 => '<p class="logged-in-as">' . sprintf( wp_kses_post( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'beautypress' ), get_edit_user_link(), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
				'id_form'			 => 'commentform',
				'id_submit'			 => 'submit',
				'class_submit'		 => 'beautypress-btn light-red-btn coment-btn',
				'title_reply'		 => esc_html__( 'Leave a Reply', 'beautypress' ),
				'title_reply_to'	 => esc_html__( 'Leave a Reply to %s', 'beautypress' ),
				'cancel_reply_link'	 => esc_html__( 'Cancel reply', 'beautypress' ),
				'label_submit'		 => esc_html__( 'Post Comment', 'beautypress' ),
				'format'			 => 'xhtml',
				'title_reply_after'=> '</h3><div class="separator"><span></span><span></span><span></span></div>'
			);

			comment_form( $defaults );
			?>
		</div>
	</div>
</div>

