<?php
/**
 * 404.php
 *
 * The template for displaying 404 pages (Not Found).
 */
get_header();
?>
<section class="beautypress-404-section">
    <div class="container">
        <div class="beautypress-404-content text-center">
            <img src="<?php echo BEAUTYPRESS_IMAGES_DIR_URI ?>/broken-pencil.png" alt="<?php esc_attr_e('404 error', 'beautypress') ?>">
            <h2 data-title="404"><span>4</span><span class="icon-404"><img src="<?php echo BEAUTYPRESS_IMAGES_DIR_URI ?>/emoji.png" alt="<?php esc_attr_e('404 error', 'beautypress') ?>"></span><span><?php esc_html_e( '4', 'beautypress' ) ?></span></h2>
            <p><?php echo beautypress_option( '404_text', esc_html__('Uh Oh! Looks Like Something Broken','beautypress'));?></p>
            <div class="beautypress-btn-wraper">
                <a href="<?php echo esc_url(beautypress_option( '404_btn_link',home_url('/') ));?>" class="beautypress-btn round-btn box-shadow-btn">
                    <?php echo beautypress_option( '404_btn_label',esc_html__('back Home','beautypress') );?>
                    <span></span>
                </a>
            </div>
        </div>
    </div>
</section>
    
<?php get_footer(); ?>