<?php
/**
 * Plugin Name: Beautypress Features
 * Plugin URI:http://xpeedstudio.com
 * Description: Beautypress Features
 * Author: xpeedstudio
 * Author URI: http://xpeedstudio.com
 * Version:1.5
 */

if ( ! defined( 'ABSPATH' ) ) exit;

define("XS_PLUGIN_DIR", plugin_dir_path(__FILE__ ));
include_once(ABSPATH . 'wp-includes/pluggable.php');
class Xs_Main{

	/**
     * Holds the class object.
     *
     * @since 1.0.0
     *
     */

	public static $_instance;

	/**
     * Plugin Name
     *
     * @since 1.0.0
     *
     */

	public $plugin_name = 'Beautypress Assistance';

	/**
     * Plugin Version
     *
     * @since 1.0.0
     *
     */

	public $plugin_version = '1.0.4';

	/**
     * Plugin File
     *
     * @since 1.0.0
     *
     */

	public $file = __FILE__;

	/**
     * Load Construct
     *
     * @since 1.0.0
     */

	public function __construct(){
		$this->xs_plugin_init();
	}

	/**
     * Plugin Initialization
     *
     * @since 1.0.0
     *
     */

	public function xs_plugin_init(){
		require_once (plugin_dir_path($this->file). 'post-type/xs-post-class.php');
		require_once (plugin_dir_path($this->file). 'init.php');
        add_action('wp_ajax_nopriv_beautypress_post_react', array($this,'beautypress_post_react'));
        add_action('wp_ajax_beautypress_post_react', array($this,'beautypress_post_react'));
        add_action('wp_ajax_nopriv_beautypress_comment_like', array($this,'beautypress_comment_like'));
        add_action('wp_ajax_beautypress_comment_like', array($this,'beautypress_comment_like'));
	}

    /**
     *
     * Post React count
     * @since 1.0.0
     *
     */

    public function beautypress_post_react() {

        check_ajax_referer('xs_post_react_nonce', 'beautypress_security');
        if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
            $like = get_post_meta( $_POST['post_id'], $_POST['meta_data'], true );
            $like = ( empty( $like ) ) ? 0 : $like;
            $like++;
            $ip = $_SERVER['REMOTE_ADDR'];
            $voted = get_post_meta( $_POST['post_id'], '_beautypress_vote', true );
            if($voted ==  $ip){
                echo esc_html__('already voted','beautypress');
            }else{
                update_post_meta( $_REQUEST['post_id'], $_POST['meta_data'], $like );
                update_post_meta( $_REQUEST['post_id'], '_beautypress_vote', $ip );
                echo esc_html($like);
            }
            wp_die();
        }
    }

    /**
     *
     * Comment Like count
     * @since 1.0.0
     *
     */

    public function beautypress_comment_like() {

        check_ajax_referer('xs_post_react_nonce', 'beautypress_security');
        if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
            $like = get_comment_meta( $_POST['comment_id'], $_POST['meta_data'], true );
            $like = ( empty( $like ) ) ? 0 : $like;
            $like++;
            $ip = $_SERVER['REMOTE_ADDR'];
            $voted = get_comment_meta( $_POST['comment_id'], '_beautypress_vote_comment', true );
            if($voted == $ip){
                echo esc_html__('already voted','beautypress');
            }else{
                update_comment_meta( $_POST['comment_id'], $_POST['meta_data'], $like );
                update_comment_meta( $_POST['comment_id'], '_beautypress_vote_comment', $ip );
                echo esc_html($like);
            }
            wp_die();
        }
    }
    public function get_social_share(){
        ?>
        <li><a class="beautypress-facebook" href="http://www.facebook.com/share.php?u=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>"><i class="fa fa-facebook"></i></a></li>
        <li><a class="beautypress-twitter" href="http://twitter.com/intent/tweet?status=<?php echo get_the_title(); ?>+<?php echo get_the_permalink(); ?>"><i class="fa fa-twitter"></i></a></li>
        <li><a class="beautypress-google-plus" href="https://plus.google.com/share?url=<?php echo get_the_permalink(); ?>"><i class="fa fa-google-plus"></i></a></li>
        <li><a class="beautypress-pinterest" href="http://pinterest.com/pin/create/bookmarklet/?url=<?php echo get_the_permalink(); ?>&is_video=false&description=<?php echo get_the_title(); ?>"><i class="fa fa-pinterest-p"></i></a></li>
        <li><a class="beautypress-facebook" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php echo get_the_permalink(); ?>&title=<?php echo get_the_title(); ?>&source=<?php echo esc_url(home_url('/')); ?>"><i class="fa fa-linkedin"></i></a></li>
        <?php
    }

    public function get_footer_widget($xs_widget){
        if($xs_widget){
            register_sidebar(
                array(
                    'name'           => esc_html__( 'Footer Widget', 'beautypress' ),
                    'id'             => 'footer-widget',
                    'description'    => esc_html__( 'Appears on posts and pages.', 'beautypress' ),
                    'before_widget'  => '<div class="footer-widget col-md-__xs-col-num__"><div id="%1$s" class="beautypress-single-footer-v2 %2$s">',
                    'after_widget'   => '</div></div>',
                    'before_title'   => '<h4 class="beautypress-footer-widget-title">',
                    'after_title'    => '</h4>',
                )
            );

            register_sidebar(
                array(
                    'name'           => esc_html__( 'Secondary Footer Widget', 'beautypress' ),
                    'id'             => 'secondary-footer-widget',
                    'description'    => esc_html__( 'Appears on posts and pages.', 'beautypress' ),
                    'before_widget'  => '<div class="footer-widget col-md-__xs-col-num__"><div id="%1$s" class="beautypress-single-footer-v2 %2$s">',
                    'after_widget'   => '</div></div>',
                    'before_title'   => '<h4 class="beautypress-footer-widget-title">',
                    'after_title'    => '</h4>',
                )
            );
        }

    }

	public static function xs_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new Xs_Main();
        }
        return self::$_instance;
    }

}
$Xs_Main = Xs_Main::xs_get_instance();
?>
