<?php if ( ! defined( 'ABSPATH' ) ) die( 'Direct access forbidden.' );

/**
 * Creates widget with recent post thumbnail
 */

class Beautypress_social extends WP_Widget{
    function __construct() {
        $widget_opt = array(
            'classname'     => 'beautypress_widget',
            'description'   => 'beautypress Social'
        );
        
        parent::__construct('xs-social', esc_html__('Beautypress Social', 'beautypress'), $widget_opt);
    }
    
    function widget( $args, $instance ){
    	global $wp_query;
        
        echo beautypress_return($args['before_widget']);
        if ( !empty( $instance[ 'title' ] ) ) {

            echo beautypress_return($args[ 'before_title' ]) . apply_filters( 'widget_title', $instance[ 'title' ] ) . beautypress_return($args[ 'after_title' ]);
        }

        $facebook = '';
        $twitter = '';
        $google = '';
        $pinterest = '';
        $youtube = '';
        $linkedin = '';
        $social_alignment = 'Center';

        if(isset($instance['facebook'])){
            $facebook = $instance['facebook'];
        }
        if(isset($instance['twitter'])){
            $twitter = $instance['twitter'];
        }
        if(isset($instance['google'])){
            $google = $instance['google'];
        }
        if(isset($instance['pinterest'])){
            $pinterest = $instance['pinterest'];
        }
        if(isset($instance['youtube'])){
            $youtube = $instance['youtube'];
        }
        if(isset($instance['linkedin'])){
            $linkedin = $instance['linkedin'];
        }
        if(isset($instance['social_alignment'])){
            $social_alignment = $instance['social_alignment'];
        }
        
        ?>
        <div class="beautypress-footer-social text-<?php echo esc_attr($social_alignment); ?>">
            <ul class="beautypress-social-list">
                <?php if($facebook != ''): ?>
                    <li><a href="<?php echo esc_url($facebook); ?>" class="beautypress-facebook"><i class="fa fa-facebook"></i></a></li>
                <?php endif; ?>

                <?php if($twitter != ''): ?>
                    <li><a href="<?php echo esc_url($twitter); ?>" class="beautypress-twitter"><i class="fa fa-twitter"></i></a></li>
                <?php endif; ?>

                <?php if($google != ''): ?>
                    <li><a href="<?php echo esc_url($google); ?>" class="beautypress-google-plus"><i class="fa fa-google-plus"></i></a></li>
                <?php endif; ?>

                <?php if($pinterest != ''): ?>
                    <li><a href="<?php echo esc_url($pinterest); ?>" class="beautypress-pinterest"><i class="fa fa-pinterest-p"></i></a></li>
                <?php endif; ?>

                <?php if($youtube != ''): ?>
                <li><a href="<?php echo esc_url($youtube); ?>" class="beautypress-instagram"><i class="fa fa-instagram"></i></a></li>
                <?php endif; ?>

                <?php if($linkedin != ''): ?>
                <li><a href="<?php echo esc_url($linkedin); ?>" class="beautypress-dribbble"><i class="fa fa-dribbble"></i></a></li>
                <?php endif; ?>
            </ul>
        </div>    
        <?php
        echo beautypress_return($args['after_widget']);
    }
    
    
    function update ( $old_instance , $new_instance) {
        $new_instance['title'] = strip_tags( $old_instance['title'] );
        $new_instance['facebook'] = $old_instance['facebook'];
        $new_instance['twitter'] = $old_instance['twitter'];
        $new_instance['google'] = $old_instance['google'];
        $new_instance['pinterest'] = $old_instance['pinterest'];
        $new_instance['youtube'] = $old_instance['youtube'];
        $new_instance['linkedin'] = $old_instance['linkedin'];
        $new_instance['social_alignment'] = $old_instance['social_alignment'];

        return $new_instance;
    	
    }
    
    function form($instance){
    	if(isset($instance['title'])){
            $title = $instance['title'];
        }
        else{
            $title = esc_html__( 'Social', 'beautypress' );
        }

        $facebook = '';
        $twitter = '';
        $google = '';
        $pinterest = '';
        $youtube = '';
        $linkedin = '';
        $social_alignment = 'Center';

        if(isset($instance['facebook'])){
            $facebook = $instance['facebook'];
        }
        if(isset($instance['twitter'])){
            $twitter = $instance['twitter'];
        }
        if(isset($instance['google'])){
            $google = $instance['google'];
        }
        if(isset($instance['pinterest'])){
            $pinterest = $instance['pinterest'];
        }
        if(isset($instance['youtube'])){
            $youtube = $instance['youtube'];
        }
        if(isset($instance['linkedin'])){
            $linkedin = $instance['linkedin'];
        }
        if(isset($instance['social_alignment'])){
            $social_alignment = $instance['social_alignment'];
        }
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e( 'Title:', 'beautypress' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'facebook' )); ?>"><?php _e( 'Facebook:' , 'beautypress' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'facebook' )); ?>" 
                       name="<?php echo esc_attr($this->get_field_name( 'facebook' )); ?>" type="text" 
                       value="<?php echo esc_attr( $facebook ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'twitter' )); ?>"><?php _e( 'Twitter:' , 'beautypress' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'twitter' )); ?>" 
                       name="<?php echo esc_attr($this->get_field_name( 'twitter' )); ?>" type="text" 
                       value="<?php echo esc_attr( $twitter ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'google' )); ?>"><?php _e( 'Google Plus:' , 'beautypress' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'google' )); ?>" 
                       name="<?php echo esc_attr($this->get_field_name( 'google' )); ?>" type="text" 
                       value="<?php echo esc_attr( $google ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'pinterest' )); ?>"><?php _e( 'Pinterest:' , 'beautypress' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'pinterest' )); ?>" 
                       name="<?php echo esc_attr($this->get_field_name( 'pinterest' )); ?>" type="text" 
                       value="<?php echo esc_attr( $pinterest ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'youtube' )); ?>"><?php _e( 'Instagram:' , 'beautypress' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'youtube' )); ?>" 
                       name="<?php echo esc_attr($this->get_field_name( 'youtube' )); ?>" type="text" 
                       value="<?php echo esc_attr( $youtube ); ?>" />
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id( 'linkedin' )); ?>"><?php _e( 'Dribbble:' , 'beautypress' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'linkedin' )); ?>" 
                       name="<?php echo esc_attr($this->get_field_name( 'linkedin' )); ?>" type="text" 
                       value="<?php echo esc_attr( $linkedin ); ?>" />
        </p>

        <p>
             <label for="<?php echo esc_attr($this->get_field_id( 'linkedin' )); ?>"><?php _e( 'Alignment:' , 'beautypress' ); ?></label>
            <?php $alignment_args = array('left','center','right') ?>
			 <select id="<?php echo esc_attr($this->get_field_id('social_alignment')); ?>" name="<?php echo esc_attr($this->get_field_name('social_alignment')); ?>" class="widefat" style="width:100%;">
                <?php foreach($alignment_args as $alignment) { ?>
				 <option <?php selected( $social_alignment, $alignment ); ?> value="<?php echo esc_attr($alignment); ?>"><?php echo esc_html($alignment); ?></option>
                <?php } ?>      
            </select>
        </p>
    <?php
    }
}
