<?php
if ( !defined( 'ABSPATH' ) )
	die( 'Direct access forbidden.' );

/**
 * Creates widget with recent post thumbnail
 */
class Beautypress_recent_post extends WP_Widget {

	function __construct() {

		$widget_opt = array(
			'classname'		 => 'beautypress_widget',
			'description'	 => 'Recent Post With Thumbnail'
		);

		parent::__construct( 'xs-recent-post', esc_html__( 'Beautypress Recent Post', 'beautypress' ), $widget_opt );
	}

	function widget( $args, $instance ) {

		global $wp_query;

		echo beautypress_return($args[ 'before_widget' ]);

		if ( !empty( $instance[ 'title' ] ) ) {

			echo beautypress_return($args[ 'before_title' ]) . apply_filters( 'widget_title', $instance[ 'title' ] ) . beautypress_return($args[ 'after_title' ]);
		}

		if ( !empty( $instance[ 'number_of_posts' ] ) ) {
			$no_of_post = $instance[ 'number_of_posts' ];
		} else {
			$no_of_post = 3;
		}


		$query = array(
			'post_type'		 => array( 'post' ),
			'post_status'	 => array( 'publish' ),
			'orderby'		 => 'date',
			'order'			 => 'DESC',
			'posts_per_page' => $no_of_post
		);

		$loop = new WP_Query( $query );
		?>
		<div class="beautypress-latest-news-wraper">
			<?php
			if ( $loop->have_posts() ):
				while ( $loop->have_posts() ):
					$loop->the_post();
					?>
					<div class="beautypress-single-latest-news">
						<div class="beautypress-latest-post-img">
							<?php
							$thumbnail	 = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), '' );
							$img  = xs_resize( $thumbnail[ 0 ], 80, 60,true );
							echo '<img src="' . esc_url( $img ) . '" alt="' . get_the_title() . '">';
							?>
						</div>
						<div class="beautypress-latest-post-content">
							<a class="caption" href="<?php echo get_the_permalink(); ?>"><?php echo get_the_title();?></a>
							<div class="date"><?php echo get_the_time( 'd F, Y' ); ?></div>

						</div>
					</div>
				<?php endwhile; ?>
			<?php else: ?>
				<div class="nopost_message">
					<p><?php echo esc_html__( 'No Post Available', 'beautypress' ) ?></p>';
				</div>
			<?php endif; ?>  
		</div>
		<?php
		wp_reset_postdata();
		echo beautypress_return($args[ 'after_widget' ]);
	}

	function update( $new_instance, $old_instance ) {

		$old_instance[ 'title' ]			 = strip_tags( $new_instance[ 'title' ] );
		$old_instance[ 'number_of_posts' ] = $new_instance[ 'number_of_posts' ];

		return $old_instance;
	}

	function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		} else {
			$title = esc_html__( 'Recent Posts', 'beautypress' );
		}
		if ( isset( $instance[ 'number_of_posts' ] ) ) {
			$no_of_post = $instance[ 'number_of_posts' ];
		} else {
			$no_of_post = 3;
		}
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php _e( 'Title:', 'beautypress' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'number_of_posts' ) ); ?>"><?php _e( 'Number Of Posts:', 'beautypress' ); ?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number_of_posts' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number_of_posts' ) ); ?>" type="text" value="<?php echo esc_attr( $no_of_post ); ?>" />
		</p>
		<?php
	}

}
